/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.softsmithy.lib.awt.AWTUtilities;
import org.softsmithy.lib.awt.event.ComponentLayoutEvent;
import org.softsmithy.lib.awt.event.ComponentLayoutListener;
import org.softsmithy.lib.swing.customizer.layout.TableConstraints;
import org.softsmithy.lib.swing.customizer.layout.TableLayout;

public abstract class AbstractTableLayout
implements TableLayout {
    private static final Dimension MAXIMUM_LAYOUT_SIZE = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private final Set<ComponentLayoutListener> allComponentLayoutListeners = new HashSet<ComponentLayoutListener>();
    private final Map<Component, Set<ComponentLayoutListener>> componentLayoutListeners = new HashMap<Component, Set<ComponentLayoutListener>>();

    protected abstract AbstractAxis getColumns();

    protected abstract AbstractAxis getRows();

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException();
    }

    @Override
    public void addLayoutComponent(Component comp, Object constr) {
        if (!(constr instanceof TableConstraints)) {
            throw new IllegalArgumentException();
        }
        this.setTableConstraints(comp, (TableConstraints)constr);
    }

    protected void validateLayout(Rectangle innerArea) {
        this.getColumns().validate(innerArea.x, innerArea.width);
        this.getRows().validate(innerArea.y, innerArea.height);
    }

    @Override
    public void invalidateLayout(Container target) {
        this.getColumns().setValid(false);
        this.getRows().setValid(false);
    }

    protected boolean isValid(Rectangle innerArea) {
        return this.getColumns().isValid(innerArea.x, innerArea.width) && this.getRows().isValid(innerArea.y, innerArea.height);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return MAXIMUM_LAYOUT_SIZE;
    }

    public void ensureValidity(Container container) {
        Rectangle innerArea = AWTUtilities.calculateInnerArea((Container)container, null);
        this.ensureValidity(innerArea);
    }

    public void ensureValidity(Rectangle innerArea) {
        if (!this.isValid(innerArea)) {
            this.validateLayout(innerArea);
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        Component[] components;
        this.ensureValidity(parent);
        for (Component component : components = this.getComponents(parent)) {
            this.layoutComponent(parent, component);
        }
    }

    @Override
    public void layoutComponent(Container parent, Component comp) {
        TableConstraints constr = this.getTableConstraints(comp);
        if (constr != null) {
            this.ensureValidity(parent);
            Rectangle bounds = constr.getAbsoluteBounds();
            comp.setBounds(bounds);
            this.fireComponentLayoutEvent(new ComponentLayoutEvent((Object)this, comp, bounds));
        }
    }

    public Component[] getComponents(Container parent) {
        return parent.getComponents();
    }

    @Override
    public void addComponentLayoutListener(ComponentLayoutListener listener) {
        this.allComponentLayoutListeners.add(listener);
    }

    @Override
    public void addComponentLayoutListener(Component component, ComponentLayoutListener listener) {
        Set<Object> listeners;
        if (this.componentLayoutListeners.containsKey(component)) {
            listeners = this.componentLayoutListeners.get(component);
        } else {
            listeners = new HashSet();
            this.componentLayoutListeners.put(component, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void removeComponentLayoutListener(ComponentLayoutListener listener) {
        this.allComponentLayoutListeners.remove(listener);
    }

    @Override
    public void removeComponentLayoutListener(Component component, ComponentLayoutListener listener) {
        if (this.componentLayoutListeners.containsKey(component)) {
            this.componentLayoutListeners.get(component).remove(listener);
        }
    }

    private void fireComponentLayoutEvent(ComponentLayoutEvent evt) {
        Iterator<ComponentLayoutListener> i = this.allComponentLayoutListeners.iterator();
        while (i.hasNext()) {
            i.next().componentLayouted(evt);
        }
        Set<ComponentLayoutListener> listeners = this.componentLayoutListeners.get(evt.getComponent());
        if (listeners != null) {
            Iterator<ComponentLayoutListener> i2 = listeners.iterator();
            while (i2.hasNext()) {
                i2.next().componentLayouted(evt);
            }
        }
    }

    protected static abstract class AbstractAxis {
        private boolean valid = false;
        private int oldInnerStart = -1;
        private int oldInnerSize = -1;

        protected AbstractAxis() {
        }

        public void ensureValidity(int innerStart, int innerSize) {
            if (!this.isValid(innerStart, innerSize)) {
                this.validate(innerStart, innerSize);
            }
        }

        public void invalidate() {
            this.setValid(false);
        }

        protected boolean isValid(int innerStart, int innerSize) {
            return this.isValid() && innerStart == this.oldInnerStart && innerSize == this.oldInnerSize;
        }

        protected boolean isValid() {
            return this.valid;
        }

        protected void setValid(boolean valid) {
            this.valid = valid;
        }

        protected void validate(int innerStart, int innerSize) {
            this.calculateSizes(innerSize);
            this.calculateOffsets(innerStart, innerSize);
            this.setValid(true);
            this.oldInnerStart = innerStart;
            this.oldInnerSize = innerSize;
        }

        protected abstract void calculateSizes(int var1);

        protected abstract void calculateOffsets(int var1, int var2);
    }
}

