/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer.action;

import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.softsmithy.lib.beans.BeanIntrospector;
import org.softsmithy.lib.swing.HorizontalAlignment;
import org.softsmithy.lib.swing.action.GeneralActionFactory;
import org.softsmithy.lib.swing.action.StandardActionFactory;
import org.softsmithy.lib.swing.action.TextActionFactory;
import org.softsmithy.lib.swing.action.XAction;
import org.softsmithy.lib.swing.customizer.JCustomizer;
import org.softsmithy.lib.swing.customizer.SelectionManager;
import org.softsmithy.lib.swing.customizer.action.CustomizerAction;
import org.softsmithy.lib.swing.customizer.action.DefaultCustomizerAction;
import org.softsmithy.lib.swing.customizer.action.ReflectiveCustomizerAction;

public class CustomizerActionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CustomizerActionFactory.class);
    private final SelectionManager selectionManager;

    public CustomizerActionFactory(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public CustomizerAction createAlignLeftAction(Locale locale) {
        return this.createCustomizerAction((StandardActionFactory)GeneralActionFactory.ALIGN_LEFT, new String[]{"x"}, locale);
    }

    private CustomizerAction createCustomizerAction(StandardActionFactory saf, String[] neededCustomizableProperties, Locale locale) {
        ReflectiveCustomizerAction action = null;
        try {
            action = new ReflectiveCustomizerAction(this, saf.toString());
            saf.configureXAction((XAction)action, locale);
            action.setNeededCustomizableProperties(new HashSet<String>(Arrays.asList(neededCustomizableProperties)));
        }
        catch (NoSuchMethodException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return action;
    }

    private CustomizerAction createDefaultCustomizerAction(StandardActionFactory saf, String[] neededCustomizableProperties, Locale locale) {
        DefaultCustomizerAction action = new DefaultCustomizerAction();
        saf.configureXAction((XAction)action, locale);
        action.setNeededCustomizableProperties(new HashSet<String>(Arrays.asList(neededCustomizableProperties)));
        return action;
    }

    public CustomizerAction createAlignTopAction(Locale locale) {
        return this.createCustomizerAction((StandardActionFactory)GeneralActionFactory.ALIGN_TOP, new String[]{"y"}, locale);
    }

    public CustomizerAction createAlignRightAction(Locale locale) {
        return this.createCustomizerAction((StandardActionFactory)GeneralActionFactory.ALIGN_RIGHT, new String[]{"x", "width"}, locale);
    }

    public CustomizerAction createAlignBottomAction(Locale locale) {
        return this.createCustomizerAction((StandardActionFactory)GeneralActionFactory.ALIGN_BOTTOM, new String[]{"y", "height"}, locale);
    }

    public CustomizerAction createAlignJustifyHorizontalAction(Locale locale) {
        return this.createCustomizerAction((StandardActionFactory)GeneralActionFactory.ALIGN_JUSTIFY_HORIZONTAL, new String[]{"width"}, locale);
    }

    public CustomizerAction createAlignJustifyVerticalAction(Locale locale) {
        return this.createCustomizerAction((StandardActionFactory)GeneralActionFactory.ALIGN_JUSTIFY_VERTICAL, new String[]{"height"}, locale);
    }

    public CustomizerAction createTextAlignLeftAction(Locale locale) {
        return this.createCustomizerAction((StandardActionFactory)TextActionFactory.ALIGN_LEFT, new String[]{"horizontalAlignment"}, locale);
    }

    public CustomizerAction createTextAlignCenterAction(Locale locale) {
        return this.createCustomizerAction((StandardActionFactory)TextActionFactory.ALIGN_CENTER, new String[]{"horizontalAlignment"}, locale);
    }

    public CustomizerAction createTextAlignRightAction(Locale locale) {
        return this.createCustomizerAction((StandardActionFactory)TextActionFactory.ALIGN_RIGHT, new String[]{"horizontalAlignment"}, locale);
    }

    public CustomizerAction createTextBoldAction(Locale locale) {
        return this.createDefaultCustomizerAction((StandardActionFactory)TextActionFactory.BOLD, new String[]{"font"}, locale);
    }

    public CustomizerAction createTextItalicAction(Locale locale) {
        return this.createDefaultCustomizerAction((StandardActionFactory)TextActionFactory.ITALIC, new String[]{"font"}, locale);
    }

    public void alignLeft(ActionEvent e) {
        this.alignHorizontal(HAlignment.LEFT, this.selectionManager.getActiveCustomizer().getX());
    }

    private void alignHorizontal(HAlignment ha, int position) {
        HashSet<JCustomizer> customizers = new HashSet<JCustomizer>(Arrays.asList(this.selectionManager.getSelectedCustomizers()));
        customizers.remove((Object)this.selectionManager.getActiveCustomizer());
        if (customizers.size() > 0) {
            ha.alignCustomizers(customizers, position, this.selectionManager.getActiveCustomizer().getComponentOrientation());
        }
    }

    public void alignTop(ActionEvent e) {
        JCustomizer[] customizers = this.selectionManager.getSelectedCustomizers();
        if (customizers.length > 0) {
            JCustomizer focusCustomizer = customizers[customizers.length - 1];
            for (int i = 0; i < customizers.length - 1; ++i) {
                customizers[i].setY(focusCustomizer.getY());
            }
        }
    }

    public void alignRight(ActionEvent e) {
        this.alignHorizontal(HAlignment.RIGHT, this.selectionManager.getActiveCustomizer().getX() + this.selectionManager.getActiveCustomizer().getWidth());
    }

    public void alignBottom(ActionEvent e) {
        JCustomizer[] customizers = this.selectionManager.getSelectedCustomizers();
        if (customizers.length > 0) {
            JCustomizer focusCustomizer = customizers[customizers.length - 1];
            for (int i = 0; i < customizers.length - 1; ++i) {
                customizers[i].setY(focusCustomizer.getY() + focusCustomizer.getHeight() - customizers[i].getHeight());
            }
        }
    }

    public void alignJustifyHorizontal(ActionEvent e) {
        JCustomizer[] customizers = this.selectionManager.getSelectedCustomizers();
        if (customizers.length > 0) {
            JCustomizer focusCustomizer = customizers[customizers.length - 1];
            for (int i = 0; i < customizers.length - 1; ++i) {
                customizers[i].setWidth(focusCustomizer.getWidth());
            }
        }
    }

    public void alignJustifyVertical(ActionEvent e) {
        JCustomizer[] customizers = this.selectionManager.getSelectedCustomizers();
        if (customizers.length > 0) {
            JCustomizer activeCustomizer = customizers[customizers.length - 1];
            for (int i = 0; i < customizers.length - 1; ++i) {
                customizers[i].setHeight(activeCustomizer.getHeight());
            }
        }
    }

    public void textAlignLeft(ActionEvent e) {
        JCustomizer[] customizers;
        for (JCustomizer customizer : customizers = this.selectionManager.getSelectedCustomizers()) {
            try {
                BeanIntrospector.setPropertyValue((String)"horizontalAlignment", (Object)HorizontalAlignment.LEFT, (Object)((Object)customizer), null);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void textAlignCenter(ActionEvent e) {
        JCustomizer[] customizers;
        for (JCustomizer customizer : customizers = this.selectionManager.getSelectedCustomizers()) {
            try {
                BeanIntrospector.setPropertyValue((String)"horizontalAlignment", (Object)HorizontalAlignment.CENTER, (Object)((Object)customizer), null);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void textAlignRight(ActionEvent e) {
        JCustomizer[] customizers;
        for (JCustomizer customizer : customizers = this.selectionManager.getSelectedCustomizers()) {
            try {
                BeanIntrospector.setPropertyValue((String)"horizontalAlignment", (Object)HorizontalAlignment.RIGHT, (Object)((Object)customizer), null);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static enum HAlignment {
        LEFT{

            @Override
            public void alignCustomizer(JCustomizer customizer, int position, ComponentOrientation co) {
                customizer.setX(position);
            }
        }
        ,
        RIGHT{

            @Override
            public void alignCustomizer(JCustomizer customizer, int position, ComponentOrientation co) {
                customizer.setX(position - customizer.getWidth());
            }
        };


        protected abstract void alignCustomizer(JCustomizer var1, int var2, ComponentOrientation var3);

        public void alignCustomizers(Collection<JCustomizer> customizers, int position, ComponentOrientation co) {
            if (customizers.size() > 0) {
                Iterator<JCustomizer> i = customizers.iterator();
                while (i.hasNext()) {
                    this.alignCustomizer(i.next(), position, co);
                }
            }
        }
    }
}

