/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TextAction;
import javax.swing.text.html.HTMLDocument;
import org.softsmithy.lib.swing.HorizontalAlignment;
import org.softsmithy.lib.swing.customizer.AbstractTextCustomizer;
import org.softsmithy.lib.swing.customizer.state.HiddenStateManager;

public class JHtmlCustomizer
extends AbstractTextCustomizer {
    private static final String HTML_START = "<html><body>";
    private static final String HTML_END = "</body></html>";
    private static final String insertHtmlBreakAction = "insert-html-break";
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    private String htmlBody = "";
    private final MutableAttributeSet attributeSet = new SimpleAttributeSet();
    private boolean inited = false;

    public JHtmlCustomizer() {
        super(new JEditorPane("text/html", "<html><body></body></html>"));
        this.setStateManager(new HiddenStateManager(this));
        this.setEditor(new JEditorPane("text/html", "<html><body></body></html>"));
        this.setEditorScrollable(true);
        this.getEditor().getInputMap().put(KeyStroke.getKeyStroke("ENTER"), insertHtmlBreakAction);
        this.getEditor().getActionMap().put(insertHtmlBreakAction, new InsertHtmlBreakAction());
        this.inited = true;
        this.setForeground(this.getForeground());
        this.setFont(this.getFont());
        this.setHorizontalAlignment(this.getHorizontalAlignment());
    }

    @Override
    public void setText(String text) {
        String newText = text;
        JEditorPane ep = (JEditorPane)this.getEditor();
        newText = newText.replaceFirst("(?s).*?<body>\\s{1,5}(<div.*?>\\s{1,7})?", "");
        newText = newText.replaceFirst("(?s)(\\s{0,5}</div>)?\\s{0,3}</body>.*?$", "");
        newText = newText.replaceAll("&lt;br&gt;", "<br>");
        this.setHtmlBody(newText);
    }

    @Override
    public void setComponent(JComponent component) {
        if (!(component instanceof JEditorPane)) {
            throw new IllegalArgumentException("comp must be a JEditorPane");
        }
        super.setComponent(component);
        JEditorPane editorPane = (JEditorPane)component;
        editorPane.setEditable(false);
        if (this.inited) {
            this.configureHtmlText();
        }
    }

    @Override
    public String getText() {
        return this.getHtmlBody();
    }

    @Override
    protected void setHorizontalAlignmentOnly(HorizontalAlignment alignment) {
        this.horizontalAlignment = alignment;
        if (this.inited) {
            StyleConstants.setAlignment(this.attributeSet, alignment.getStyleConstant(this.getComponentOrientation()));
            this.configureHtmlText();
        }
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    private void configureHtmlText() {
        JEditorPane editorPane = (JEditorPane)this.getComponent();
        if (editorPane != null) {
            editorPane.setDocument(editorPane.getEditorKit().createDefaultDocument());
            editorPane.setText(this.createHtmlText());
            HTMLDocument doc = (HTMLDocument)editorPane.getDocument();
            doc.setParagraphAttributes(0, doc.getLength(), this.attributeSet, true);
        }
    }

    private String createHtmlText() {
        StringBuilder htmlText = new StringBuilder(HTML_START);
        htmlText.append(this.getText());
        htmlText.append(HTML_END);
        return htmlText.toString();
    }

    @Override
    public void setDefaultForeground(Color c) {
        super.setDefaultForeground(c);
        if (this.inited) {
            StyleConstants.setForeground(this.attributeSet, c);
            this.configureHtmlText();
            this.repaint();
        }
    }

    @Override
    public void setDefaultFont(Font f) {
        super.setDefaultFont(f);
        if (this.inited) {
            StyleConstants.setFontFamily(this.attributeSet, f.getFamily());
            StyleConstants.setFontSize(this.attributeSet, f.getSize());
            StyleConstants.setBold(this.attributeSet, f.isBold());
            StyleConstants.setItalic(this.attributeSet, f.isItalic());
            this.configureHtmlText();
            this.repaint();
        }
    }

    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        String newHtmlBody;
        this.htmlBody = newHtmlBody = htmlBody;
        this.configureHtmlText();
    }

    private static class InsertHtmlBreakAction
    extends TextAction {
        public InsertHtmlBreakAction() {
            super(JHtmlCustomizer.insertHtmlBreakAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(target);
                    return;
                }
                target.replaceSelection("<br>\n");
            }
        }
    }
}

