/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.Font;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.softsmithy.lib.beans.BeanIntrospector;
import org.softsmithy.lib.beans.ReflectivePropertyChangeListener;
import org.softsmithy.lib.swing.HorizontalAlignment;
import org.softsmithy.lib.swing.customizer.JCustomizer;
import org.softsmithy.lib.swing.customizer.event.CustomizerSelectionEvent;
import org.softsmithy.lib.swing.customizer.event.CustomizerSelectionListener;

public class CustomizerPropertyButtonManager
implements CustomizerSelectionListener {
    private static final Logger LOG = LoggerFactory.getLogger(CustomizerPropertyButtonManager.class);
    private JCustomizer activeCustomizer = null;
    private final Set<AbstractButton> textBoldButtons = new HashSet<AbstractButton>();
    private final Set<AbstractButton> textItalicButtons = new HashSet<AbstractButton>();
    private final Set<AbstractButton> textAlignLeftButtons = new HashSet<AbstractButton>();
    private final Set<AbstractButton> textAlignCenterButtons = new HashSet<AbstractButton>();
    private final Set<AbstractButton> textAlignRightButtons = new HashSet<AbstractButton>();
    private final Set<CustomizerPropertyChangeListener> listeners = new HashSet<CustomizerPropertyChangeListener>();
    private CustomizerPropertyChangeListener textBold = null;
    private CustomizerPropertyChangeListener textItalic = null;
    private CustomizerPropertyChangeListener textAlignLeft = null;
    private CustomizerPropertyChangeListener textAlignCenter = null;
    private CustomizerPropertyChangeListener textAlignRight = null;

    public void textBold(PropertyChangeEvent e) {
        this.setSelection(this.textBoldButtons, ((Font)e.getNewValue()).isBold());
    }

    public void textItalic(PropertyChangeEvent e) {
        this.setSelection(this.textItalicButtons, ((Font)e.getNewValue()).isItalic());
    }

    public void textAlignLeft(PropertyChangeEvent e) {
        if (((HorizontalAlignment)e.getNewValue()).orient(this.activeCustomizer.getComponentOrientation()).equals((Object)HorizontalAlignment.LEFT)) {
            this.setSelection(this.textAlignLeftButtons, true);
        }
    }

    public void textAlignCenter(PropertyChangeEvent e) {
        if (((HorizontalAlignment)e.getNewValue()).equals((Object)HorizontalAlignment.CENTER)) {
            this.setSelection(this.textAlignCenterButtons, true);
        }
    }

    public void textAlignRight(PropertyChangeEvent e) {
        if (((HorizontalAlignment)e.getNewValue()).orient(this.activeCustomizer.getComponentOrientation()).equals((Object)HorizontalAlignment.RIGHT)) {
            this.setSelection(this.textAlignRightButtons, true);
        }
    }

    private void setSelection(Set<AbstractButton> buttons, boolean selected) {
        buttons.forEach(button -> button.setSelected(selected));
    }

    @Override
    public void selectionChanged(CustomizerSelectionEvent e) {
        this.removeListeners();
        this.activeCustomizer = e.getActiveCustomizer();
        this.addListeners();
        this.initButtons(this.activeCustomizer, e.getCommonCustomizableProperties());
    }

    private void removeListeners() {
        if (this.activeCustomizer != null) {
            this.listeners.forEach(listener -> this.activeCustomizer.removePropertyChangeListener(listener.getPropertyName(), (PropertyChangeListener)((Object)listener)));
        }
    }

    private void addListeners() {
        if (this.activeCustomizer != null) {
            this.listeners.forEach(listener -> this.activeCustomizer.addPropertyChangeListener(listener.getPropertyName(), (PropertyChangeListener)((Object)listener)));
        }
    }

    private void initButtons(JCustomizer activeCustomizer, Set commonCustomizableProperties) {
        block10: {
            if (activeCustomizer != null) {
                if (commonCustomizableProperties.contains("font")) {
                    Font font = activeCustomizer.getFont();
                    this.setSelection(this.textBoldButtons, font.isBold());
                    this.setSelection(this.textItalicButtons, font.isItalic());
                } else {
                    this.setDefaultFontSelection();
                }
                if (commonCustomizableProperties.contains("horizontalAlignment")) {
                    try {
                        HorizontalAlignment ha = ((HorizontalAlignment)BeanIntrospector.getPropertyDescriptor((String)"horizontalAlignment", ((Object)((Object)activeCustomizer)).getClass(), null).getReadMethod().invoke((Object)activeCustomizer, new Object[0])).orient(activeCustomizer.getComponentOrientation());
                        if (ha.equals((Object)HorizontalAlignment.LEFT)) {
                            this.setSelection(this.textAlignLeftButtons, true);
                            break block10;
                        }
                        if (ha.equals((Object)HorizontalAlignment.CENTER)) {
                            this.setSelection(this.textAlignCenterButtons, true);
                            break block10;
                        }
                        this.setSelection(this.textAlignRightButtons, true);
                    }
                    catch (IntrospectionException | IllegalAccessException | RuntimeException | InvocationTargetException ex) {
                        LOG.error(ex.getMessage(), (Throwable)ex);
                        this.setDefaultHorizontalAlignmentSelection();
                    }
                } else {
                    this.setDefaultHorizontalAlignmentSelection();
                }
            } else {
                this.setDefaultFontSelection();
                this.setDefaultHorizontalAlignmentSelection();
            }
        }
    }

    private void setDefaultFontSelection() {
        this.setSelection(this.textBoldButtons, false);
        this.setSelection(this.textItalicButtons, false);
    }

    private void setDefaultHorizontalAlignmentSelection() {
        this.setSelection(this.textAlignLeftButtons, true);
    }

    public void addTextBoldButton(AbstractButton button) {
        if (this.textBoldButtons.isEmpty()) {
            this.listeners.add(this.getTextBoldPropertyChangeListener());
        }
        this.textBoldButtons.add(button);
    }

    public void addTextItalicButton(AbstractButton button) {
        if (this.textItalicButtons.isEmpty()) {
            this.listeners.add(this.getTextItalicPropertyChangeListener());
        }
        this.textItalicButtons.add(button);
    }

    public void addTextAlignLeftButton(AbstractButton button) {
        if (this.textAlignLeftButtons.isEmpty()) {
            this.listeners.add(this.getTextAlignLeftPropertyChangeListener());
        }
        this.textAlignLeftButtons.add(button);
    }

    public void addTextAlignCenterButton(AbstractButton button) {
        if (this.textAlignCenterButtons.isEmpty()) {
            this.listeners.add(this.getTextAlignCenterPropertyChangeListener());
        }
        this.textAlignCenterButtons.add(button);
    }

    public void addTextAlignRightButton(AbstractButton button) {
        if (this.textAlignRightButtons.isEmpty()) {
            this.listeners.add(this.getTextAlignRightPropertyChangeListener());
        }
        this.textAlignRightButtons.add(button);
    }

    public void removeTextBoldButton(AbstractButton button) {
        this.textBoldButtons.remove(button);
        if (this.textBoldButtons.isEmpty()) {
            this.listeners.remove((Object)this.getTextBoldPropertyChangeListener());
        }
    }

    public void removeTextItalicButton(AbstractButton button) {
        this.textItalicButtons.remove(button);
        if (this.textItalicButtons.isEmpty()) {
            this.listeners.remove((Object)this.getTextItalicPropertyChangeListener());
        }
    }

    public void removeTextAlignLeftButton(AbstractButton button) {
        this.textAlignLeftButtons.remove(button);
        if (this.textAlignLeftButtons.isEmpty()) {
            this.listeners.remove((Object)this.getTextAlignLeftPropertyChangeListener());
        }
    }

    public void removeTextAlignCenterButton(AbstractButton button) {
        this.textAlignCenterButtons.remove(button);
        if (this.textAlignCenterButtons.isEmpty()) {
            this.listeners.remove((Object)this.getTextAlignCenterPropertyChangeListener());
        }
    }

    public void removeTextAlignRightButton(AbstractButton button) {
        this.textAlignRightButtons.remove(button);
        if (this.textAlignRightButtons.isEmpty()) {
            this.listeners.remove((Object)this.getTextAlignRightPropertyChangeListener());
        }
    }

    private CustomizerPropertyChangeListener getTextBoldPropertyChangeListener() {
        if (this.textBold == null) {
            try {
                this.textBold = new CustomizerPropertyChangeListener(this, "textBold", "font");
            }
            catch (NoSuchMethodException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.textBold;
    }

    private CustomizerPropertyChangeListener getTextItalicPropertyChangeListener() {
        if (this.textItalic == null) {
            try {
                this.textItalic = new CustomizerPropertyChangeListener(this, "textItalic", "font");
            }
            catch (NoSuchMethodException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.textItalic;
    }

    private CustomizerPropertyChangeListener getTextAlignLeftPropertyChangeListener() {
        if (this.textAlignLeft == null) {
            try {
                this.textAlignLeft = new CustomizerPropertyChangeListener(this, "textAlignLeft", "horizontalAlignment");
            }
            catch (NoSuchMethodException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.textAlignLeft;
    }

    private CustomizerPropertyChangeListener getTextAlignCenterPropertyChangeListener() {
        if (this.textAlignCenter == null) {
            try {
                this.textAlignCenter = new CustomizerPropertyChangeListener(this, "textAlignCenter", "horizontalAlignment");
            }
            catch (NoSuchMethodException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.textAlignCenter;
    }

    private CustomizerPropertyChangeListener getTextAlignRightPropertyChangeListener() {
        if (this.textAlignRight == null) {
            try {
                this.textAlignRight = new CustomizerPropertyChangeListener(this, "textAlignRight", "horizontalAlignment");
            }
            catch (NoSuchMethodException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.textAlignRight;
    }

    private static class CustomizerPropertyChangeListener
    extends ReflectivePropertyChangeListener {
        private final String propertyName;

        public CustomizerPropertyChangeListener(Object target, String methodName, String propertyName) throws NoSuchMethodException {
            super(target, methodName);
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

