/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.softsmithy.lib.swing.customizer.JCustomizerPane;
import org.softsmithy.lib.swing.customizer.event.CustomizerSelectionEvent;
import org.softsmithy.lib.swing.customizer.event.CustomizerSelectionListener;

public class ActivationManager
implements FocusListener,
CustomizerSelectionListener {
    private JCustomizerPane activePane;
    private final Set<JCustomizerPane> panes = new HashSet<JCustomizerPane>();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void setActiveCustomizerPane(JCustomizerPane pane) {
        if (!(pane == null && this.activePane == null || pane.equals(this.activePane))) {
            JCustomizerPane oldActivePane = this.activePane;
            if (pane != null) {
                pane.setActive(true);
            }
            if (this.activePane != null) {
                this.activePane.setActive(false);
            }
            this.activePane = pane;
            this.propertyChangeSupport.firePropertyChange("active", oldActivePane, this.activePane);
        }
    }

    public JCustomizerPane getActiveCustomizerPane() {
        return this.activePane;
    }

    @Override
    public void selectionChanged(CustomizerSelectionEvent e) {
        if (e.getActiveCustomizer() != null && this.panes.contains(e.getActiveCustomizer().getParentCustomizerPane())) {
            this.setActiveCustomizerPane(e.getActiveCustomizer().getParentCustomizerPane());
        }
    }

    public void addCustomizerPane(JCustomizerPane pane) {
        pane.addFocusListener(this);
        pane.getSelectionManager().addCustomizerSelectionListener(this);
        pane.setActivationBorderEnabled(true);
        this.panes.add(pane);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setActiveCustomizerPane((JCustomizerPane)((Object)e.getComponent()));
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void removeCustomizerPane(JCustomizerPane pane) {
        pane.removeFocusListener(this);
        this.panes.remove(pane);
        boolean same = false;
        Iterator<JCustomizerPane> i = this.panes.iterator();
        while (i.hasNext()) {
            if (!i.next().getSelectionManager().equals(pane.getSelectionManager())) continue;
            same = true;
            break;
        }
        if (!same) {
            pane.getSelectionManager().removeCustomizerSelectionListener(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener("active", l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener("active", l);
    }
}

