/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.Cursor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.softsmithy.lib.swing.HorizontalAlignment;
import org.softsmithy.lib.swing.customizer.JCustomizer;
import org.softsmithy.lib.swing.customizer.state.EditableStateManager;
import org.softsmithy.lib.swing.customizer.state.StateManager;

public abstract class AbstractTextCustomizer
extends JCustomizer {
    private JTextComponent editor = new JTextField();
    private boolean editorScrollable = false;
    private boolean editable;
    private boolean inited = false;

    public AbstractTextCustomizer() {
        this.init();
    }

    public AbstractTextCustomizer(JComponent component) {
        super(component);
        this.init();
    }

    private void init() {
        this.setEditable(true);
        this.setStateManager(new EditableStateManager(this));
        this.inited = true;
    }

    public void setEditor(JTextComponent editor) {
        this.editor = editor;
        editor.setCursor(Cursor.getPredefinedCursor(2));
    }

    public JTextComponent getEditor() {
        return this.editor;
    }

    public abstract String getText();

    public abstract void setText(String var1);

    protected abstract void setHorizontalAlignmentOnly(HorizontalAlignment var1);

    public abstract HorizontalAlignment getHorizontalAlignment();

    public void setHorizontalAlignment(HorizontalAlignment alignment) {
        HorizontalAlignment oldValue = this.getHorizontalAlignment();
        if (!alignment.equals((Object)oldValue)) {
            this.setHorizontalAlignmentOnly(alignment);
            this.repaint();
            this.firePropertyChange("horizontalAlignment", oldValue, alignment);
        }
    }

    protected EditableStateManager getEditableStateManager() {
        return (EditableStateManager)this.getStateManager();
    }

    protected void setEditableStateManager(EditableStateManager stateManager) {
        this.setStateManager(stateManager);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[" + this.getText() + "]";
    }

    public boolean isEditorScrollable() {
        return this.editorScrollable;
    }

    public void setEditorScrollable(boolean editorScrollable) {
        this.editorScrollable = editorScrollable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    protected void setStateManager(StateManager manager) {
        if (this.inited && !(manager instanceof EditableStateManager)) {
            throw new IllegalArgumentException("manager must be an instance of EditableStateManager!");
        }
        super.setStateManager(manager);
    }
}

