/*
 *         COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Notice
 *
 * The contents of this file are subject to the COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL)
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.opensource.org/licenses/cddl1.txt
 *
 * The Original Code is SoftSmithy Utility Library. The Initial Developer of the
 * Original Code is Florian Brunner (Sourceforge.net user: puce). All Rights Reserved.
 *
 * Contributor(s): .
 */

/*
 * JTreeCustomizerBar.java
 *
 * Created on 27. Februar 2003, 19:20
 */

package org.softsmithy.lib.swing.customizer;

import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;
import org.softsmithy.lib.swing.JXTree;

/**
 *
 * @author  puce
 */
public abstract class JTreeCustomizerBar extends JPanel implements CustomizerBar {
  
  private JXTree tree;
  
  
  public JTreeCustomizerBar(TreeModel newModel){
    this(new JXTree(newModel));
  }
  
  public JTreeCustomizerBar(TreeNode root){
    this(new JXTree(root));
  }
  
 public JTreeCustomizerBar(JXTree tree){
   this.tree = tree;
    initComponents();
    tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
    JScrollPane scrollPane = new JScrollPane(tree);
    add(scrollPane, BorderLayout.CENTER);
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.BorderLayout());
    }// </editor-fold>//GEN-END:initComponents
  
  
  @Override
  public boolean hasSelection() {
    return ! tree.isSelectionEmpty();
  }
  
  @Override
  public void clearSelection() {
    tree.clearSelection();
  }
  
  public JXTree getTree(){
    return tree;
  }
  
  public Object getSelectedNode(){
    return tree.getSelectedNode();
  }
  
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
  
}
