/*
 *         COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Notice
 *
 * The contents of this file are subject to the COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL)
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.opensource.org/licenses/cddl1.txt
 *
 * The Original Code is SoftSmithy Utility Library. The Initial Developer of the
 * Original Code is Florian Brunner (Sourceforge.net user: puce). All Rights Reserved.
 *
 * Contributor(s): .
 */

/*
 * JCustomizerPane.java
 *
 * Created on 21. August 2002, 16:20
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.plaf.ComponentUI;
import org.softsmithy.lib.awt.event.ComponentLayoutListener;
import org.softsmithy.lib.swing.customizer.layout.CustomizerConstraints;
import org.softsmithy.lib.swing.customizer.layout.CustomizerLayout;
import org.softsmithy.lib.swing.customizer.layout.InfiniteTableLayout;

/**
 *
 * @author  puce
 */
public class JCustomizerPane extends AbstractCustomizer implements MouseListener {

    /** Holds value of property showingLayoutHelp. */
    private boolean showingLayoutHelp = true;
    /** Holds value of property selectionManager. */
    private SelectionManager selectionManager = new SelectionManager();
    /** Holds value of property customizerBar. */
    private CustomizerBar customizerBar;
    //private final ActivationManager activationManager = new ActivationManager();
    /** Holds value of property active. */
    private boolean active = false;
    private boolean inited = false;
    /** Holds value of property activationBorderEnabled. */
    private boolean activationBorderEnabled = false;
    /** Holds value of property activeBorderColor. */
    private Color activeBorderColor = Color.GREEN;
    /** Holds value of property inactiveBorderColor. */
    private Color inactiveBorderColor = Color.LIGHT_GRAY;
    /** Holds value of property layoutHelpColor. */
    private Color layoutHelpColor = Color.LIGHT_GRAY;
    /** Holds value of property defaultNormalCustomizerBorderColor. */
    private Color defaultNormalCustomizerBorderColor = Color.GRAY;
    /** Holds value of property defaultSelectedCustomizerBorderColor. */
    private Color defaultSelectedCustomizerBorderColor = Color.BLUE;

    /** Creates new form JCustomizerPane */
    public JCustomizerPane() {
        initComponents();
        inited = true;
        setLayout(new InfiniteTableLayout(this));
        setSize(400, 300);
        //setFocusable(true);//setRequestFocusEnabled(true);
        addMouseListener(this);
        this.setBackground(Color.WHITE);
        //    Action deleteAction = new AbstractAction("delete") {
        //      public void actionPerformed(ActionEvent e) {
        //        System.out.println(e.getSource() + " deleted!");
        //      }
        //    };
        //    getActionMap().put(deleteAction.getValue(Action.NAME),
        //    deleteAction);
        //
        //    getInputMap(WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke("DELETE"),
        //    deleteAction.getValue(Action.NAME));

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(null);
    }// </editor-fold>//GEN-END:initComponents

    /** Getter for property showingConstraints.
     * @return Value of property showingConstraints.
     */
    public boolean isShowingLayoutHelp() {
        return this.showingLayoutHelp;
    }

    /** Setter for property showingLayoutHelp.
     * @param showingLayoutHelp New value of property showingLayoutHelp.
     */
    public void setShowingLayoutHelp(boolean showingLayoutHelp) {
        this.showingLayoutHelp = showingLayoutHelp;
    }

    /** Calls the UI delegate's paint method, if the UI delegate
     * is non-<code>null</code>.  We pass the delegate a copy of the
     * <code>Graphics</code> object to protect the rest of the
     * paint code from irrevocable changes
     * (for example, <code>Graphics.translate</code>).
     * <p>
     * If you override this in a subclass you should not make permanent
     * changes to the passed in <code>Graphics</code>. For example, you
     * should not alter the clip <code>Rectangle</code> or modify the
     * transform. If you need to do these operations you may find it
     * easier to create a new <code>Graphics</code> from the passed in
     * <code>Graphics</code> and manipulate it. Further, if you do not
     * invoker super's implementation you must honor the opaque property,
     * that is
     * if this component is opaque, you must completely fill in the background
     * in a non-opaque color. If you do not honor the opaque property you
     * will likely see visual artifacts.
     *
     * @param g the <code>Graphics</code> object to protect
     * @see #paint
     * @see ComponentUI
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (isShowingLayoutHelp()) {
            Color oldColor = g.getColor();
            g.setColor(getLayoutHelpColor());
            getCustomizerLayout().drawLayoutHelp(this, g);
            g.setColor(oldColor);
        }
        /* First painting occurs at (x,y), where x is at least
        insets.left, and y is at least insets.height. */
    }

    /** Invoked when the mouse button has been clicked (pressed
     * and released) on a component.
     *
     */
    @Override
    public void mouseClicked(MouseEvent e) {
    }

    /** Invoked when the mouse enters a component.
     *
     */
    @Override
    public void mouseEntered(MouseEvent e) {
    }

    /** Invoked when the mouse exits a component.
     *
     */
    @Override
    public void mouseExited(MouseEvent e) {
    }

    /** Invoked when a mouse button has been released on a component.
     *
     */
    @Override
    public void mouseReleased(MouseEvent e) {
    }

    /** Getter for property selectionManager.
     * @return Value of property selectionManager.
     *
     */
    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    /** Invoked when a mouse button has been pressed on a component.
     *
     */
    @Override
    public void mousePressed(MouseEvent e) {
        if (!hasFocus()) {
            requestFocus();
            getSelectionManager().clearSelection();
        }
        if (customizerBar != null && customizerBar.hasSelection()) {
            customizerBar.consumeSelection(this, e.getPoint());
        }
    }

    /** Getter for property customizerBar.
     * @return Value of property customizerBar.
     *
     */
    public CustomizerBar getCustomizerBar() {
        return this.customizerBar;
    }

    /** Setter for property customizerBar.
     * @param customizerBar New value of property customizerBar.
     *
     */
    public void setCustomizerBar(CustomizerBar customizerBar) {
        this.customizerBar = customizerBar;
    }

    /** Setter for property selectionManager.
     * @param selectionManager New value of property selectionManager.
     *
     */
    public void setSelectionManager(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public JCustomizer[] getCustomizers() {
        return Arrays.asList(getComponents()).
                toArray(new JCustomizer[getComponents().length]);
    }

    public JCustomizer[] getIntersectedCustomizers(Rectangle2D rectangle) {
        List<JCustomizer> customizers = new ArrayList<>();
        JCustomizer[] allCustomizers = getCustomizers();
        for (JCustomizer customizer : allCustomizers) {
            if (customizer.getBounds().intersects(rectangle)) {
                customizers.add(customizer);
            }
        }
        return customizers.toArray(new JCustomizer[customizers.size()]);
    }

    /**
     * Sets the layout manager for this container.
     * @param mgr the specified layout manager
     * @see #doLayout
     * @see #getLayout
     *
     */
    @Override
    public void setLayout(LayoutManager mgr) {
        if (inited) {
            if (!(mgr instanceof CustomizerLayout)) {
                throw new IllegalArgumentException(
                        "mgr must be an instance of CustomizerLayout!");
            }
        }
        super.setLayout(mgr);
    }

    public void setCustomizerLayout(CustomizerLayout cl) {
        setLayout(cl);
    }

    public CustomizerLayout getCustomizerLayout() {
        return (CustomizerLayout) getLayout();
    }

    /** Adds the specified component to this container at the specified
     * index. This method also notifies the layout manager to add
     * the component to this container's layout using the specified
     * constraints object via the <code>addLayoutComponent</code>
     * method.  The constraints are
     * defined by the particular layout manager being used.  For
     * example, the <code>BorderLayout</code> class defines five
     * constraints: <code>BorderLayout.NORTH</code>,
     * <code>BorderLayout.SOUTH</code>, <code>BorderLayout.EAST</code>,
     * <code>BorderLayout.WEST</code>, and <code>BorderLayout.CENTER</code>.
     *
     * <p>Note that if the component already exists
     * in this container or a child of this container,
     * it is removed from that container before
     * being added to this container.
     * <p>
     * This is the method to override if a program needs to track
     * every add request to a container as all other add methods defer
     * to this one. An overriding method should
     * usually include a call to the superclass's version of the method:
     * <p>
     * <blockquote>
     * <code>super.addImpl(comp, constraints, index)</code>
     * </blockquote>
     * <p>
     * @param     comp       the component to be added
     * @param     constraints an object expressing layout constraints
     *                 for this component
     * @param     index the position in the container's list at which to
     *                 insert the component, where <code>-1</code>
     *                 means append to the end
     * @exception IllegalArgumentException if <code>index</code> is invalid
     * @exception IllegalArgumentException if adding the container's parent
     * 			to itself
     * @exception IllegalArgumentException if adding a window to a container
     * @see       #add(Component)
     * @see       #add(Component, int)
     * @see       #add(Component, java.lang.Object)
     * @see       LayoutManager
     * @see       LayoutManager2
     * @since     JDK1.1
     *
     */
    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof JCustomizer)) {
            throw new IllegalArgumentException(
                    "comp must be an instance of JCustomizer!");
        }
        if (!(constraints instanceof CustomizerConstraints)) {
            throw new IllegalArgumentException(
                    "constraints must be an instance of CustomizerConstraints!");
        }
        //((JCustomizer) comp).registerListeners(this);
        super.addImpl(comp, constraints, index);
    }

    public void addCustomizer(JCustomizer customizer,
            CustomizerConstraints constraints) {
        add(customizer, constraints);
    }

    public void setAbsoluteCustomizerBounds(JCustomizer customizer,
            Rectangle bounds) {
        getCustomizerLayout().setAbsoluteBounds(customizer, bounds);
    }

    public void addComponentLayoutListener(ComponentLayoutListener listener) {
        getCustomizerLayout().addComponentLayoutListener(listener);
    }

    public void addComponentLayoutListener(Component component,
            ComponentLayoutListener listener) {
        getCustomizerLayout().addComponentLayoutListener(component, listener);
    }

    public void removeComponentLayoutListener(ComponentLayoutListener listener) {
        getCustomizerLayout().removeComponentLayoutListener(listener);
    }

    public void removeComponentLayoutListener(Component component,
            ComponentLayoutListener listener) {
        getCustomizerLayout().removeComponentLayoutListener(component, listener);
    }

    /** Getter for property active.
     * @return Value of property active.
     *
     */
    public boolean isActive() {
        return this.active;
    }

    /** Setter for property active.
     * @param active New value of property active.
     *
     */
    public void setActive(boolean active) {
        if (active != isActive()) {
            boolean oldActive = isActive();
            this.active = active;
            if (isActivationBorderEnabled()) {
                setActivationBorder();
            }
            firePropertyChange("active", oldActive, active);
        }
    }

    /** Getter for property activationBorderEnabled.
     * @return Value of property activationBorderEnabled.
     *
     */
    public boolean isActivationBorderEnabled() {
        return this.activationBorderEnabled;
    }

    /** Setter for property activationBorderEnabled.
     * @param activationBorderEnabled New value of property activationBorderEnabled.
     *
     */
    public void setActivationBorderEnabled(boolean activationBorderEnabled) {
        this.activationBorderEnabled = activationBorderEnabled;
        if (activationBorderEnabled) {
            setActivationBorder();
        }
    }

    /** Getter for property activeBorderColor.
     * @return Value of property activeBorderColor.
     *
     */
    public Color getActiveBorderColor() {
        return this.activeBorderColor;
    }

    /** Setter for property activeBorderColor.
     * @param activeBorderColor New value of property activeBorderColor.
     *
     */
    public void setActiveBorderColor(Color activeBorderColor) {
        this.activeBorderColor = activeBorderColor;
        if (isActivationBorderEnabled()) {
            setActivationBorder();
        }
    }

    /** Getter for property inactiveBorderColor.
     * @return Value of property inactiveBorderColor.
     *
     */
    public Color getInactiveBorderColor() {
        return this.inactiveBorderColor;
    }

    /** Setter for property inactiveBorderColor.
     * @param inactiveBorderColor New value of property inactiveBorderColor.
     *
     */
    public void setInactiveBorderColor(Color inactiveBorderColor) {
        this.inactiveBorderColor = inactiveBorderColor;
        if (isActivationBorderEnabled()) {
            setActivationBorder();
        }
    }

    private void setActivationBorder() {
        if (isActive()) {
            setBorder(BorderFactory.createLineBorder(getActiveBorderColor()));
        } else {
            setBorder(BorderFactory.createLineBorder(getInactiveBorderColor()));
        }
    }

    /** Getter for property layoutHelpColor.
     * @return Value of property layoutHelpColor.
     *
     */
    public Color getLayoutHelpColor() {
        return this.layoutHelpColor;
    }

    /** Setter for property layoutHelpColor.
     * @param layoutHelpColor New value of property layoutHelpColor.
     *
     */
    public void setLayoutHelpColor(Color layoutHelpColor) {
        this.layoutHelpColor = layoutHelpColor;
        repaint();
    }

    /** Getter for property defaultNormalCustomizerBorderColor.
     * @return Value of property defaultNormalCustomizerBorderColor.
     *
     */
    public Color getDefaultNormalCustomizerBorderColor() {
        return this.defaultNormalCustomizerBorderColor;
    }

    /** Setter for property defaultNormalCustomizerBorderColor.
     * @param defaultNormalCustomizerBorderColor New value of property defaultNormalCustomizerBorderColor.
     *
     */
    public void setDefaultNormalCustomizerBorderColor(
            Color defaultNormalCustomizerBorderColor) {
        Color oldDefaultNormalCustomizerBorderColor =
                this.defaultNormalCustomizerBorderColor;
        this.defaultNormalCustomizerBorderColor =
                defaultNormalCustomizerBorderColor;
        //System.out.println("defaultNormalCustomizerBorderColor changed");
        firePropertyChange("defaultNormalCustomizerBorderColor",
                oldDefaultNormalCustomizerBorderColor,
                defaultNormalCustomizerBorderColor);
    }

    /** Getter for property defaultSelectedCustomizerBorderColor.
     * @return Value of property defaultSelectedCustomizerBorderColor.
     *
     */
    public Color getDefaultSelectedCustomizerBorderColor() {
        return this.defaultSelectedCustomizerBorderColor;
    }

    /** Setter for property defaultSelectedCustomizerBorderColor.
     * @param defaultSelectedCustomizerBorderColor New value of property defaultSelectedCustomizerBorderColor.
     *
     */
    public void setDefaultSelectedCustomizerBorderColor(
            Color defaultSelectedCustomizerBorderColor) {
        Color oldDefaultSelectedCustomizerBorderColor =
                this.defaultSelectedCustomizerBorderColor;
        this.defaultSelectedCustomizerBorderColor =
                defaultSelectedCustomizerBorderColor;
        firePropertyChange("defaultSelectedCustomizerBorderColor",
                oldDefaultSelectedCustomizerBorderColor,
                defaultSelectedCustomizerBorderColor);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
