/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;

public class HandleBorder
extends AbstractBorder {
    private final Color fLineColor;
    private final int fThick;
    private final int fLineInset;
    private final Handle fNHandle;
    private final Handle fNEHandle;
    private final Handle fEHandle;
    private final Handle fSEHandle;
    private final Handle fSHandle;
    private final Handle fSWHandle;
    private final Handle fWHandle;
    private final Handle fNWHandle;
    private final Handle[] fHandles;

    public HandleBorder() {
        this(Color.black, 6);
    }

    public HandleBorder(Color lineColor, int lineInset) {
        this(6, lineColor, lineInset);
    }

    public HandleBorder(Color lineColor) {
        this(6, lineColor);
    }

    public HandleBorder(int thick, Color lineColor) {
        this(thick, lineColor, thick / 2);
    }

    public HandleBorder(int thick) {
        this(thick, Color.black);
    }

    public HandleBorder(final int thick, Color lineColor, int lineInset) {
        this.fLineColor = lineColor;
        this.fThick = thick;
        this.fLineInset = lineInset;
        this.fNHandle = new Handle(thick){
            private Rectangle fRect;

            @Override
            public void setRect(int w, int h) {
                this.fRect = new Rectangle(w / 2 - thick / 2, 0, thick, thick);
            }

            @Override
            protected Rectangle getRect() {
                return this.fRect;
            }
        };
        this.fNEHandle = new Handle(thick){
            private Rectangle fRect;

            @Override
            public void setRect(int w, int h) {
                this.fRect = new Rectangle(w - thick, 0, thick, thick);
            }

            @Override
            protected Rectangle getRect() {
                return this.fRect;
            }
        };
        this.fEHandle = new Handle(thick){
            private Rectangle fRect;

            @Override
            public void setRect(int w, int h) {
                this.fRect = new Rectangle(w - thick, h / 2 - thick / 2, thick, thick);
            }

            @Override
            protected Rectangle getRect() {
                return this.fRect;
            }
        };
        this.fSEHandle = new Handle(thick){
            private Rectangle fRect;

            @Override
            public void setRect(int w, int h) {
                this.fRect = new Rectangle(w - thick, h - thick, thick, thick);
            }

            @Override
            protected Rectangle getRect() {
                return this.fRect;
            }
        };
        this.fSHandle = new Handle(thick){
            private Rectangle fRect;

            @Override
            public void setRect(int w, int h) {
                this.fRect = new Rectangle(w / 2 - thick / 2, h - thick, thick, thick);
            }

            @Override
            protected Rectangle getRect() {
                return this.fRect;
            }
        };
        this.fSWHandle = new Handle(thick){
            private Rectangle fRect;

            @Override
            public void setRect(int w, int h) {
                this.fRect = new Rectangle(0, h - thick, thick, thick);
            }

            @Override
            protected Rectangle getRect() {
                return this.fRect;
            }
        };
        this.fWHandle = new Handle(thick){
            private Rectangle fRect;

            @Override
            public void setRect(int w, int h) {
                this.fRect = new Rectangle(0, h / 2 - thick / 2, thick, thick);
            }

            @Override
            protected Rectangle getRect() {
                return this.fRect;
            }
        };
        this.fNWHandle = new Handle(thick){
            private final Rectangle fRect;
            {
                super(thick2);
                this.fRect = new Rectangle(0, 0, thick, thick);
            }

            @Override
            public void setRect(int w, int h) {
            }

            @Override
            protected Rectangle getRect() {
                return this.fRect;
            }
        };
        this.fHandles = new Handle[]{this.fNHandle, this.fNEHandle, this.fEHandle, this.fSEHandle, this.fSHandle, this.fSWHandle, this.fWHandle, this.fNWHandle};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Graphics copy = g.create();
        if (copy != null) {
            try {
                copy.translate(x, y);
                this.paintRectangle(c, copy, w, h);
                this.paintHandles(c, copy, w, h);
            }
            finally {
                copy.dispose();
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.fLineInset + 1;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    protected void paintRectangle(Component c, Graphics g, int w, int h) {
        g.setColor(this.fLineColor);
        g.drawRect(this.fLineInset, this.fLineInset, w - 2 * this.fLineInset - 1, h - 2 * this.fLineInset - 1);
    }

    protected void paintHandles(Component c, Graphics g, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.fLineColor);
        for (int i = 0; i < this.fHandles.length; ++i) {
            this.fHandles[i].paint(c, g2, w, h);
        }
    }

    public Handle getNHandle() {
        return this.fNHandle;
    }

    public Handle getNEHandle() {
        return this.fNEHandle;
    }

    public Handle getEHandle() {
        return this.fEHandle;
    }

    public Handle getSEHandle() {
        return this.fSEHandle;
    }

    public Handle getSHandle() {
        return this.fSHandle;
    }

    public Handle getSWHandle() {
        return this.fSWHandle;
    }

    public Handle getWHandle() {
        return this.fWHandle;
    }

    public Handle getNWHandle() {
        return this.fNWHandle;
    }

    public Handle getHandleAt(Point p) {
        Handle handle = null;
        for (int i = 0; i < this.fHandles.length; ++i) {
            if (!this.fHandles[i].contains(p)) continue;
            handle = this.fHandles[i];
            break;
        }
        return handle;
    }

    public Handle[] getHandles() {
        return this.fHandles;
    }

    public static abstract class Handle {
        private final int fThick;

        public Handle(int thick) {
            this.fThick = thick;
        }

        public void paint(Component c, Graphics2D g, int w, int h) {
            this.setRect(w, h);
            g.fill(this.getRect());
        }

        public abstract void setRect(int var1, int var2);

        protected abstract Rectangle getRect();

        public boolean contains(Point p) {
            return this.getRect().contains(p);
        }
    }
}

