/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer.state;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import org.softsmithy.lib.swing.customizer.JCustomizer;
import org.softsmithy.lib.swing.customizer.JCustomizerPane;
import org.softsmithy.lib.swing.customizer.border.HandleBorder;
import org.softsmithy.lib.swing.customizer.state.AbstractState;
import org.softsmithy.lib.swing.customizer.state.State;

public class StateManager
implements FocusListener,
MouseInputListener {
    private JCustomizer customizer;
    private State current;
    private final State normalState;
    private final State selectedState;
    private final BoundState moveState;
    private final ResizeState nResizeState;
    private final ResizeState nEResizeState;
    private final ResizeState eResizeState;
    private final ResizeState sEResizeState;
    private final ResizeState sResizeState;
    private final ResizeState sWResizeState;
    private final ResizeState wResizeState;
    private final ResizeState nWResizeState;
    private final ResizeState[] resizeStates;
    private final BorderColor defaultNormalBorderColor = new DefaultNormalBorderColor();
    private final BorderColor defaultSelectedBorderColor = new DefaultSelectedBorderColor();
    private final CustomBorderColor customNormalBorderColor = new CustomBorderColor(Color.GRAY);
    private final CustomBorderColor customSelectedBorderColor = new CustomBorderColor(Color.BLUE);
    private BorderColor currentNormalBorderColor;
    private BorderColor currentSelectedBorderColor;

    public StateManager(JCustomizer customizer) {
        this.customizer = customizer;
        this.normalState = new NormalState(customizer);
        this.selectedState = new SelectedState(customizer);
        this.moveState = new MoveState(customizer);
        this.nResizeState = new NResizeState(customizer);
        this.nEResizeState = new NEResizeState(customizer);
        this.eResizeState = new EResizeState(customizer);
        this.sEResizeState = new SEResizeState(customizer);
        this.sResizeState = new SResizeState(customizer);
        this.sWResizeState = new SWResizeState(customizer);
        this.wResizeState = new WResizeState(customizer);
        this.nWResizeState = new NWResizeState(customizer);
        this.resizeStates = new ResizeState[]{this.nResizeState, this.nEResizeState, this.eResizeState, this.sEResizeState, this.sResizeState, this.sWResizeState, this.wResizeState, this.nWResizeState};
        this.setUsingDefaultNormalBorderColor(true);
        this.setUsingDefaultSelectedBorderColor(true);
        this.setState(this.normalState);
    }

    protected void setState(State state) {
        if (this.current != null) {
            this.current.unconfigureCustomizer();
            this.current.setActive(false);
        }
        this.current = state;
        this.current.configureCustomizer();
        this.current.setActive(true);
    }

    public void setStateBound(Point point) {
        BoundState state = this.getBoundStateAt(point);
        state.setStart(point);
        this.setState(state);
        this.customizer.invalidate();
        this.customizer.doLayout();
    }

    private BoundState getBoundStateAt(Point p) {
        BoundState state = this.moveState;
        for (int i = 0; i < this.resizeStates.length; ++i) {
            if (!this.resizeStates[i].contains(p)) continue;
            state = this.resizeStates[i];
            break;
        }
        return state;
    }

    public JCustomizer getCustomizer() {
        return this.customizer;
    }

    public void configureCustomizer() {
    }

    public void unconfigureCustomizer() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.current.mouseClicked(e);
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.current.mouseDragged(e);
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.current.mouseEntered(e);
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.current.mouseExited(e);
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.current.mouseMoved(e);
        e.consume();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.current.mousePressed(e);
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.current.mouseReleased(e);
        e.consume();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.current.focusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.current.focusLost(e);
    }

    public ResizeState getNResizeState() {
        return this.nResizeState;
    }

    public ResizeState getEResizeState() {
        return this.eResizeState;
    }

    public ResizeState getNWResizeState() {
        return this.nWResizeState;
    }

    public State getNormalState() {
        return this.normalState;
    }

    public ResizeState getNEResizeState() {
        return this.nEResizeState;
    }

    public BoundState getMoveState() {
        return this.moveState;
    }

    public State getSelectedState() {
        return this.selectedState;
    }

    public ResizeState getSEResizeState() {
        return this.sEResizeState;
    }

    public ResizeState getSResizeState() {
        return this.sResizeState;
    }

    public ResizeState getSWResizeState() {
        return this.sWResizeState;
    }

    public ResizeState getWResizeState() {
        return this.wResizeState;
    }

    public void setStateNResize() {
        this.setState(this.nResizeState);
    }

    public void setStateEResize() {
        this.setState(this.eResizeState);
    }

    public void setStateNWResize() {
        this.setState(this.nWResizeState);
    }

    public void setStateNormal() {
        this.setState(this.normalState);
    }

    public void setStateNEResize() {
        this.setState(this.nEResizeState);
    }

    public void setStateMove() {
        this.setState(this.moveState);
    }

    public void setStateSelected() {
        this.setState(this.selectedState);
    }

    public void setStateSEResize() {
        this.setState(this.sEResizeState);
    }

    public void setStateSResize() {
        this.setState(this.sResizeState);
    }

    public void setStateSWResize() {
        this.setState(this.sWResizeState);
    }

    public void setStateWResize() {
        this.setState(this.wResizeState);
    }

    public Color getNormalBorderColor() {
        return this.getCurrentNormalBorderColor().getColor();
    }

    public Color getSelectedBorderColor() {
        return this.getCurrentSelectedBorderColor().getColor();
    }

    public boolean isUsingDefaultNormalBorderColor() {
        return this.getCurrentNormalBorderColor().isDefault();
    }

    public void setUsingDefaultNormalBorderColor(boolean usingDefaultNormalBorderColor) {
        if (usingDefaultNormalBorderColor) {
            this.setCurrentNormalBorderColor(this.defaultNormalBorderColor);
        } else {
            this.setCurrentNormalBorderColor(this.customNormalBorderColor);
        }
    }

    public boolean isUsingDefaultSelectedBorderColor() {
        return this.getCurrentSelectedBorderColor().isDefault();
    }

    public void setUsingDefaultSelectedBorderColor(boolean usingDefaultSelectedBorderColor) {
        if (usingDefaultSelectedBorderColor) {
            this.setCurrentSelectedBorderColor(this.defaultSelectedBorderColor);
        } else {
            this.setCurrentSelectedBorderColor(this.customSelectedBorderColor);
        }
    }

    private BorderColor getDefaultNormalBorderColor() {
        return this.defaultNormalBorderColor;
    }

    private BorderColor getDefaultSelectedBorderColor() {
        return this.defaultSelectedBorderColor;
    }

    public Color getCustomNormalBorderColor() {
        return this.customNormalBorderColor.getColor();
    }

    public void setCustomNormalBorderColor(Color color) {
        this.customNormalBorderColor.setColor(color);
    }

    public Color getCustomSelectedBorderColor() {
        return this.customSelectedBorderColor.getColor();
    }

    public void setCustomSelectedBorderColor(Color color) {
        this.customSelectedBorderColor.setColor(color);
    }

    private BorderColor getCurrentNormalBorderColor() {
        return this.currentNormalBorderColor;
    }

    private void setCurrentNormalBorderColor(BorderColor currentNormalBorderColor) {
        if (this.currentNormalBorderColor != null) {
            this.currentNormalBorderColor.stopListening();
        }
        this.currentNormalBorderColor = currentNormalBorderColor;
        this.currentNormalBorderColor.startListening();
        this.getNormalState().resetBorder(currentNormalBorderColor.getColor());
    }

    private BorderColor getCurrentSelectedBorderColor() {
        return this.currentSelectedBorderColor;
    }

    public void setCurrentSelectedBorderColor(BorderColor currentSelectedBorderColor) {
        if (this.currentSelectedBorderColor != null) {
            this.currentSelectedBorderColor.stopListening();
        }
        this.currentSelectedBorderColor = currentSelectedBorderColor;
        this.currentSelectedBorderColor.startListening();
        this.resetSelectedBorder();
    }

    private void resetSelectedBorder() {
        this.getSelectedState().resetBorder(this.getCurrentSelectedBorderColor().getColor());
        this.getMoveState().resetBorder(this.getCurrentSelectedBorderColor().getColor());
        for (int i = 0; i < this.resizeStates.length; ++i) {
            this.resizeStates[i].setBorder(this.getMoveState().getBorder());
        }
    }

    private static class CustomBorderColor
    implements BorderColor {
        private Color color;

        public CustomBorderColor(Color color) {
            this.color = color;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        public boolean isDefault() {
            return false;
        }

        @Override
        public void startListening() {
        }

        @Override
        public void stopListening() {
        }
    }

    private class DefaultSelectedBorderColor
    extends AbstractDefaultBorderColor {
        private HierarchyListener parentListener;
        private PropertyChangeListener defaultSelectedCustomizerBorderColorListener;

        private DefaultSelectedBorderColor() {
            this.parentListener = new ParentListener();
            this.defaultSelectedCustomizerBorderColorListener = new DefaultSelectedCustomizerBorderColorListener();
        }

        @Override
        public Color getColor() {
            return StateManager.this.getCustomizer().getParentCustomizerPane() != null ? StateManager.this.getCustomizer().getParentCustomizerPane().getDefaultSelectedCustomizerBorderColor() : StateManager.this.customSelectedBorderColor.getColor();
        }

        @Override
        public void startListening() {
            StateManager.this.getCustomizer().addHierarchyListener(this.parentListener);
            if (StateManager.this.getCustomizer().getParentCustomizerPane() != null) {
                StateManager.this.getCustomizer().getParentCustomizerPane().addPropertyChangeListener("defaultSelectedCustomizerBorderColor", this.defaultSelectedCustomizerBorderColorListener);
            }
        }

        @Override
        public void stopListening() {
            StateManager.this.getCustomizer().removeHierarchyListener(this.parentListener);
            if (StateManager.this.getCustomizer().getParentCustomizerPane() != null) {
                StateManager.this.getCustomizer().getParentCustomizerPane().removePropertyChangeListener("defaultSelectedCustomizerBorderColor", this.defaultSelectedCustomizerBorderColorListener);
            }
        }

        private class DefaultSelectedCustomizerBorderColorListener
        implements PropertyChangeListener {
            private DefaultSelectedCustomizerBorderColorListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StateManager.this.resetSelectedBorder();
            }
        }

        private class ParentListener
        implements HierarchyListener {
            private ParentListener() {
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getChangedParent() != null) {
                    e.getChangedParent().removePropertyChangeListener("defaultSelectedCustomizerBorderColor", DefaultSelectedBorderColor.this.defaultSelectedCustomizerBorderColorListener);
                }
                if (StateManager.this.getCustomizer().getParentCustomizerPane() != null) {
                    StateManager.this.getCustomizer().getParentCustomizerPane().addPropertyChangeListener("defaultSelectedCustomizerBorderColor", DefaultSelectedBorderColor.this.defaultSelectedCustomizerBorderColorListener);
                }
                StateManager.this.resetSelectedBorder();
            }
        }
    }

    private class DefaultNormalBorderColor
    extends AbstractDefaultBorderColor {
        private HierarchyListener parentListener;
        private PropertyChangeListener defaultNormalCustomizerBorderColorListener;

        private DefaultNormalBorderColor() {
            this.parentListener = new ParentListener();
            this.defaultNormalCustomizerBorderColorListener = new DefaultNormalCustomizerBorderColorListener();
        }

        @Override
        public Color getColor() {
            return StateManager.this.getCustomizer().getParentCustomizerPane() != null ? StateManager.this.getCustomizer().getParentCustomizerPane().getDefaultNormalCustomizerBorderColor() : StateManager.this.customNormalBorderColor.getColor();
        }

        @Override
        public void startListening() {
            StateManager.this.getCustomizer().addHierarchyListener(this.parentListener);
            if (StateManager.this.getCustomizer().getParentCustomizerPane() != null) {
                StateManager.this.getCustomizer().getParentCustomizerPane().addPropertyChangeListener("defaultNormalCustomizerBorderColor", this.defaultNormalCustomizerBorderColorListener);
            }
        }

        @Override
        public void stopListening() {
            StateManager.this.getCustomizer().removeHierarchyListener(this.parentListener);
            if (StateManager.this.getCustomizer().getParentCustomizerPane() != null) {
                StateManager.this.getCustomizer().getParentCustomizerPane().removePropertyChangeListener("defaultNormalCustomizerBorderColor", this.defaultNormalCustomizerBorderColorListener);
            }
        }

        private class DefaultNormalCustomizerBorderColorListener
        implements PropertyChangeListener {
            private DefaultNormalCustomizerBorderColorListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StateManager.this.getNormalState().resetBorder(DefaultNormalBorderColor.this.getColor());
            }
        }

        private class ParentListener
        implements HierarchyListener {
            private ParentListener() {
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getChangedParent() != null) {
                    e.getChangedParent().removePropertyChangeListener("defaultNormalCustomizerBorderColor", DefaultNormalBorderColor.this.defaultNormalCustomizerBorderColorListener);
                }
                if (StateManager.this.getCustomizer().getParentCustomizerPane() != null) {
                    StateManager.this.getCustomizer().getParentCustomizerPane().addPropertyChangeListener("defaultNormalCustomizerBorderColor", DefaultNormalBorderColor.this.defaultNormalCustomizerBorderColorListener);
                }
                StateManager.this.getNormalState().resetBorder(DefaultNormalBorderColor.this.getColor());
            }
        }
    }

    private static abstract class AbstractDefaultBorderColor
    implements BorderColor {
        private AbstractDefaultBorderColor() {
        }

        @Override
        public boolean isDefault() {
            return true;
        }
    }

    private static interface BorderColor {
        public Color getColor();

        public boolean isDefault();

        public void startListening();

        public void stopListening();
    }

    private static class NWResizeState
    extends ResizeState {
        public NWResizeState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void applyCursor() {
            this.getCustomizer().setCursor(Cursor.getPredefinedCursor(6));
        }

        @Override
        public HandleBorder.Handle getHandle() {
            return this.getHandleBorder().getNWHandle();
        }

        @Override
        public Rectangle createRelRectangle(MouseEvent e) {
            return this.createRelRectangle(e, 1, 1, -1, -1);
        }
    }

    private static class WResizeState
    extends ResizeState {
        public WResizeState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void applyCursor() {
            this.getCustomizer().setCursor(Cursor.getPredefinedCursor(10));
        }

        @Override
        public HandleBorder.Handle getHandle() {
            return this.getHandleBorder().getWHandle();
        }

        @Override
        public Rectangle createRelRectangle(MouseEvent e) {
            return this.createRelRectangle(e, 1, 0, -1, 0);
        }
    }

    private static class SWResizeState
    extends ResizeState {
        public SWResizeState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void applyCursor() {
            this.getCustomizer().setCursor(Cursor.getPredefinedCursor(4));
        }

        @Override
        public HandleBorder.Handle getHandle() {
            return this.getHandleBorder().getSWHandle();
        }

        @Override
        public Rectangle createRelRectangle(MouseEvent e) {
            return this.createRelRectangle(e, 1, 0, -1, 1);
        }
    }

    private static class SResizeState
    extends ResizeState {
        public SResizeState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void applyCursor() {
            this.getCustomizer().setCursor(Cursor.getPredefinedCursor(9));
        }

        @Override
        public HandleBorder.Handle getHandle() {
            return this.getHandleBorder().getSHandle();
        }

        @Override
        public Rectangle createRelRectangle(MouseEvent e) {
            return this.createRelRectangle(e, 0, 0, 0, 1);
        }
    }

    private static class SEResizeState
    extends ResizeState {
        public SEResizeState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void applyCursor() {
            this.getCustomizer().setCursor(Cursor.getPredefinedCursor(5));
        }

        @Override
        public HandleBorder.Handle getHandle() {
            return this.getHandleBorder().getSEHandle();
        }

        @Override
        public Rectangle createRelRectangle(MouseEvent e) {
            return this.createRelRectangle(e, 0, 0, 1, 1);
        }
    }

    private static class EResizeState
    extends ResizeState {
        public EResizeState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void applyCursor() {
            this.getCustomizer().setCursor(Cursor.getPredefinedCursor(11));
        }

        @Override
        public HandleBorder.Handle getHandle() {
            return this.getHandleBorder().getEHandle();
        }

        @Override
        public Rectangle createRelRectangle(MouseEvent e) {
            return this.createRelRectangle(e, 0, 0, 1, 0);
        }
    }

    private static class NEResizeState
    extends ResizeState {
        public NEResizeState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void applyCursor() {
            this.getCustomizer().setCursor(Cursor.getPredefinedCursor(7));
        }

        @Override
        public HandleBorder.Handle getHandle() {
            return this.getHandleBorder().getNEHandle();
        }

        @Override
        public Rectangle createRelRectangle(MouseEvent e) {
            return this.createRelRectangle(e, 0, 1, 1, -1);
        }
    }

    private static class NResizeState
    extends ResizeState {
        public NResizeState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void applyCursor() {
            this.getCustomizer().setCursor(Cursor.getPredefinedCursor(8));
        }

        @Override
        public HandleBorder.Handle getHandle() {
            return this.getHandleBorder().getNHandle();
        }

        @Override
        public Rectangle createRelRectangle(MouseEvent e) {
            return this.createRelRectangle(e, 0, 1, 0, -1);
        }
    }

    public static abstract class ResizeState
    extends BoundState {
        private boolean draggingStarted = false;

        public ResizeState(JCustomizer customizer) {
            super(customizer);
        }

        public abstract HandleBorder.Handle getHandle();

        public boolean contains(Point p) {
            return this.getHandle().contains(p);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.draggingStarted) {
                StateManager manager = this.getCustomizer().getStateManager();
                manager.setState(manager.getMoveState());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.draggingStarted = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.draggingStarted = false;
        }
    }

    private static class MoveState
    extends BoundState {
        public MoveState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void applyCursor() {
            this.getCustomizer().setCursor(Cursor.getPredefinedCursor(13));
        }

        @Override
        public Rectangle createRelRectangle(MouseEvent e) {
            return this.createRelRectangle(e, 1, 1, 0, 0);
        }
    }

    public static abstract class BoundState
    extends DefaultState {
        private int startX;
        private int startY;
        private boolean dragging;
        private int lastX;
        private int lastY;

        public BoundState(JCustomizer customizer) {
            super(customizer);
        }

        public HandleBorder getHandleBorder() {
            return (HandleBorder)this.getBorder();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            StateManager manager = this.getCustomizer().getStateManager();
            BoundState state = manager.getBoundStateAt(e.getPoint());
            if (state != this) {
                manager.setState(state);
            }
        }

        public int getStartX() {
            return this.startX;
        }

        public int getStartY() {
            return this.startY;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.startX = e.getX();
            this.startY = e.getY();
            this.lastX = e.getX();
            this.lastY = e.getY();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            if (!this.isDragging()) {
                this.dragging = true;
            }
            Rectangle relRect = this.createRelRectangle(e);
            this.getCustomizer().setBoundsRel(relRect.x, relRect.y, relRect.width, relRect.height);
            this.lastX = e.getX();
            this.lastY = e.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isDragging()) {
                Rectangle relRect = this.createRelRectangle(e);
                this.getCustomizer().reshapeRel(relRect.x, relRect.y, relRect.width, relRect.height);
                this.dragging = false;
            }
        }

        public abstract Rectangle createRelRectangle(MouseEvent var1);

        public Rectangle createRelRectangle(MouseEvent e, int xFactor, int yFactor, int widthFactor, int heightFactor) {
            int dx = e.getX() - this.getStartX();
            int dy = e.getY() - this.getStartY();
            int dwidth = xFactor == 0 ? e.getX() - this.getLastX() : e.getX() - this.getStartX();
            int dheight = yFactor == 0 ? e.getY() - this.getLastY() : e.getY() - this.getStartY();
            return new Rectangle(xFactor * dx, yFactor * dy, widthFactor * dwidth, heightFactor * dheight);
        }

        public int getLastX() {
            return this.lastX;
        }

        public int getLastY() {
            return this.lastY;
        }

        public void setStart(Point point) {
            this.startX = point.x;
            this.startY = point.y;
        }

        public boolean isDragging() {
            return this.dragging;
        }

        @Override
        public void resetBorder(Color borderColor) {
            this.setBorder(new HandleBorder(borderColor, 0));
            for (int i = 0; i < this.getHandleBorder().getHandles().length; ++i) {
                this.getHandleBorder().getHandles()[i].setRect(this.getCustomizer().getWidth(), this.getCustomizer().getHeight());
            }
        }
    }

    private static class SelectedState
    extends DefaultState {
        public SelectedState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JCustomizerPane pane = (JCustomizerPane)((Object)this.getCustomizer().getParent());
            if (e.isControlDown()) {
                pane.getSelectionManager().deselect(this.getCustomizer());
            } else {
                pane.getSelectionManager().singleSelect(this.getCustomizer(), e.getPoint());
            }
        }
    }

    private static class NormalState
    extends DefaultState {
        public NormalState(JCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JCustomizerPane pane = (JCustomizerPane)((Object)this.getCustomizer().getParent());
            if (e.isControlDown()) {
                pane.getSelectionManager().select(this.getCustomizer(), e.getPoint());
            } else {
                pane.getSelectionManager().singleSelect(this.getCustomizer(), e.getPoint());
            }
        }
    }

    public static class DefaultState
    extends AbstractState {
        private Border border;
        private final JCustomizer customizer;

        public DefaultState(JCustomizer customizer) {
            this.customizer = customizer;
        }

        @Override
        public void applyBorder() {
            this.customizer.applyBorder(this.border);
        }

        @Override
        public void applyCursor() {
            this.customizer.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void resetBorder(Color borderColor) {
            this.setBorder(BorderFactory.createLineBorder(borderColor, 1));
        }

        public Border getBorder() {
            return this.border;
        }

        public void setBorder(Border border) {
            this.border = border;
            if (this.isActive()) {
                this.applyBorder();
            }
        }

        @Override
        public void configureCustomizer() {
            this.applyBorder();
            this.applyCursor();
        }

        @Override
        public JCustomizer getCustomizer() {
            return this.customizer;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                JCustomizerPane pane = (JCustomizerPane)((Object)this.getCustomizer().getParent());
                pane.getSelectionManager().singleSelect(this.getCustomizer(), e.getPoint());
                this.getCustomizer().fireActionEvent(new ActionEvent((Object)this.getCustomizer(), 1001, ""));
            }
        }
    }
}

