/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer.layout;

import java.awt.Component;
import java.awt.Rectangle;
import org.softsmithy.lib.swing.customizer.layout.AbstractTableConstraints;
import org.softsmithy.lib.swing.customizer.layout.TableLayout;

public class AbsoluteTableConstraints
extends AbstractTableConstraints {
    private int x;
    private int y;
    private int width;
    private int height;

    public AbsoluteTableConstraints(int x, int y, int width, int height, Component component, TableLayout tl) {
        this(new Rectangle(x, y, width, height), component, tl);
    }

    public AbsoluteTableConstraints(Rectangle bounds, Component component, TableLayout tl) {
        super(component, tl);
        this.setAbsoluteBounds(bounds);
    }

    @Override
    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.setXOnly(x);
        this.updateTableLayout();
    }

    private void setXOnly(int x) {
        this.x = this.getTableLayout().adjustX(x);
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.setYOnly(y);
        this.updateTableLayout();
    }

    private void setYOnly(int y) {
        this.y = this.getTableLayout().adjustY(y);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.setWidthOnly(width);
        this.updateTableLayout();
    }

    private void setWidthOnly(int width) {
        this.width = this.getTableLayout().adjustWidth(this.getX(), width);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.setHeightOnly(height);
        this.updateTableLayout();
    }

    private void setHeightOnly(int height) {
        this.height = this.getTableLayout().adjustHeight(this.getY(), height);
    }

    @Override
    protected void setAbsoluteBoundsOnly(Rectangle bounds) {
        Rectangle adjustedBounds = this.getTableLayout().adjustBounds(bounds);
        this.x = adjustedBounds.x;
        this.y = adjustedBounds.y;
        this.width = adjustedBounds.width;
        this.height = adjustedBounds.height;
    }

    @Override
    public Rectangle getAbsoluteBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public Rectangle getRelativeBounds() {
        int column = this.getTableLayout().columnIndex(this.x);
        int row = this.getTableLayout().rowIndex(this.y);
        return new Rectangle(column, row, this.getTableLayout().colSpan(column, this.width), this.getTableLayout().rowSpan(row, this.height));
    }

    @Override
    protected void setRelativeBoundsOnly(Rectangle bounds) {
        this.setX(this.getTableLayout().xLocation(bounds.x));
        this.setY(this.getTableLayout().yLocation(bounds.y));
        this.setWidth(this.getTableLayout().width(bounds.x, bounds.width));
        this.setHeight(this.getTableLayout().height(bounds.y, bounds.height));
    }
}

