/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.softsmithy.lib.beans.BeanIntrospector;
import org.softsmithy.lib.swing.customizer.JCustomizer;
import org.softsmithy.lib.swing.customizer.event.CustomizerEvent;
import org.softsmithy.lib.swing.customizer.event.CustomizerListener;
import org.softsmithy.lib.swing.customizer.event.CustomizerSelectionEvent;
import org.softsmithy.lib.swing.customizer.event.CustomizerSelectionListener;

public class SelectionManager
implements PropertyChangeListener,
CustomizerListener {
    private final List<JCustomizer> selectedList = new ArrayList<JCustomizer>();
    private final Set<JCustomizer> selectedSet = new LinkedHashSet<JCustomizer>();
    private JCustomizer activeCustomizer = null;
    private Set<CustomizerSelectionListener> listeners = new HashSet<CustomizerSelectionListener>();
    private boolean fireingSelectionChanged = false;
    private Set<String> commonCustomizableProperties = new LinkedHashSet<String>();
    private int dxFactor = 0;
    private int dyFactor = 0;
    private int dwidthFactor = 0;
    private int dheightFactor = 0;

    public void select(JCustomizer customizer, Point point) {
        this.selectOnly(customizer);
        customizer.getStateManager().setStateBound(point);
        this.fireSelectionChanged();
    }

    public void select(JCustomizer customizer) {
        this.selectOnly(customizer);
        customizer.getStateManager().setStateMove();
        this.fireSelectionChanged();
    }

    private void selectOnly(JCustomizer customizer) {
        if (this.getActiveCustomizer() != null) {
            this.getActiveCustomizer().getStateManager().setStateSelected();
        }
        this.setSelected(customizer);
        if (!customizer.hasFocus()) {
            customizer.requestFocus();
        }
        this.revalidate();
    }

    public void singleSelect(JCustomizer customizer, Point point) {
        this.clearSelectionOnly();
        this.select(customizer, point);
    }

    public void singleSelect(JCustomizer customizer) {
        this.clearSelectionOnly();
        this.select(customizer);
    }

    public void deselect(JCustomizer customizer) {
        JCustomizer last = null;
        JCustomizer secondLast = null;
        int size = this.selectedList.size();
        if (size > 0) {
            last = this.selectedList.get(size - 1);
            if (size > 1) {
                secondLast = this.selectedList.get(size - 2);
            }
        }
        if (((Object)((Object)customizer)).equals((Object)last) && secondLast != null) {
            secondLast.getStateManager().setStateMove();
        }
        customizer.getStateManager().setStateNormal();
        this.setDeselected(customizer);
        this.revalidate();
        this.fireSelectionChanged();
    }

    public boolean isSelected(JCustomizer customizer) {
        return this.selectedSet.contains((Object)customizer);
    }

    private void setSelected(JCustomizer customizer) {
        this.ensureAppendedLast(customizer);
        this.selectedList.add(customizer);
        this.selectedSet.add(customizer);
    }

    private void setDeselected(JCustomizer customizer) {
        this.selectedList.remove((Object)customizer);
        this.selectedSet.remove((Object)customizer);
    }

    public void clearSelection() {
        this.clearSelectionOnly();
        this.fireSelectionChanged();
    }

    private void clearSelectionOnly() {
        for (JCustomizer customizer : this.selectedList) {
            customizer.getStateManager().setStateNormal();
        }
        this.selectedList.clear();
        this.selectedSet.clear();
        this.revalidate();
    }

    private void ensureAppendedLast(JCustomizer customizer) {
        if (this.isSelected(customizer)) {
            this.setDeselected(customizer);
        }
    }

    public void deleteSelection() {
        for (int i = 0; i < this.selectedList.size(); ++i) {
            JCustomizer customizer = this.selectedList.get(i);
            Container parent = customizer.getParent();
            if (!parent.hasFocus()) {
                parent.requestFocus();
            }
            Rectangle bounds = customizer.getBounds();
            parent.remove((Component)((Object)customizer));
            parent.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        this.clearSelection();
    }

    public void addCustomizerSelectionListener(CustomizerSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeCustomizerSelectionListener(CustomizerSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSelectionChanged() {
        this.fireingSelectionChanged = true;
        CustomizerSelectionEvent e = new CustomizerSelectionEvent(this, Collections.unmodifiableSet(this.selectedSet), this.getActiveCustomizer(), this.getCommonCustomizableProperties());
        Iterator<CustomizerSelectionListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().selectionChanged(e);
        }
        this.fireingSelectionChanged = false;
    }

    public JCustomizer[] getSelectedCustomizers() {
        return this.selectedList.toArray(new JCustomizer[this.selectedList.size()]);
    }

    public JCustomizer getActiveCustomizer() {
        return this.activeCustomizer;
    }

    public boolean isFireingSelectionChanged() {
        return this.fireingSelectionChanged;
    }

    public Set<String> getCommonCustomizableProperties() {
        return this.commonCustomizableProperties;
    }

    private void revalidate() {
        if (this.getActiveCustomizer() != null) {
            this.getActiveCustomizer().removeCustomizerListener(this);
            Iterator<String> i = this.commonCustomizableProperties.iterator();
            while (i.hasNext()) {
                this.getActiveCustomizer().removePropertyChangeListener(i.next(), this);
            }
        }
        this.activeCustomizer = this.selectedList.isEmpty() ? null : this.selectedList.get(this.selectedList.size() - 1);
        this.commonCustomizableProperties = JCustomizer.getCommonCustomizableProperties(this.selectedSet);
        this.resetFactors();
        if (this.getActiveCustomizer() != null) {
            this.getActiveCustomizer().addCustomizerListener(this);
            for (String property : this.commonCustomizableProperties) {
                this.getActiveCustomizer().addPropertyChangeListener(property, this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        for (int i = 0; i < this.selectedList.size() - 1; ++i) {
            JCustomizer customizer = this.selectedList.get(i);
            try {
                BeanIntrospector.setPropertyValue((String)evt.getPropertyName(), (Object)evt.getNewValue(), (Object)((Object)customizer), null);
                customizer.repaint();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void customizerResetBoundsRel(CustomizerEvent e) {
        for (int i = 0; i < this.selectedList.size() - 1; ++i) {
            JCustomizer customizer = this.selectedList.get(i);
            customizer.setBoundsRel(this.dxFactor * e.getDx(), this.dyFactor * e.getDy(), this.dwidthFactor * e.getDwidth(), this.dheightFactor * e.getDheight());
        }
    }

    @Override
    public void customizerReshapeRel(CustomizerEvent e) {
        for (int i = 0; i < this.selectedList.size() - 1; ++i) {
            this.selectedList.get(i).reshapeRel(this.dxFactor * e.getDx(), this.dyFactor * e.getDy(), this.dwidthFactor * e.getDwidth(), this.dheightFactor * e.getDheight());
        }
    }

    private void resetFactors() {
        this.dxFactor = this.commonCustomizableProperties.contains("x") ? 1 : 0;
        this.dyFactor = this.commonCustomizableProperties.contains("y") ? 1 : 0;
        this.dwidthFactor = this.commonCustomizableProperties.contains("width") ? 1 : 0;
        this.dheightFactor = this.commonCustomizableProperties.contains("height") ? 1 : 0;
    }
}

