/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Line2D;
import org.softsmithy.lib.swing.customizer.JXIconCustomizer;
import org.softsmithy.lib.swing.customizer.Line2DOrientation;
import org.softsmithy.lib.swing.icon.ShapeIcon;
import org.softsmithy.lib.swing.icon.XIcon;

public class JLine2DCustomizer
extends JXIconCustomizer {
    private Line2DOrientation orientation;
    private Line2DIcon lineIcon = new Line2DIcon();

    public JLine2DCustomizer() {
        this.setOrientation(Line2DOrientation.HORIZONTAL);
    }

    public Line2D getLine2D() {
        return this.lineIcon.getLine2D();
    }

    public void setLine2D(Line2D line2D) {
        this.lineIcon.setShape(line2D);
        this.setXIcon((XIcon)this.lineIcon);
        this.revalidate();
    }

    @Override
    public void setXIcon(XIcon icon) {
        if (!(icon instanceof Line2DIcon)) {
            throw new IllegalArgumentException("icon must be a Line2DIcon");
        }
        super.setXIcon((XIcon)((Line2DIcon)icon));
    }

    public Line2DOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Line2DOrientation orientation) {
        this.orientation = orientation;
        this.setLine2D(orientation.getLine2D());
    }

    public float getThickness() {
        return ((BasicStroke)this.lineIcon.getStroke()).getLineWidth();
    }

    public void setThickness(float thickness) {
        BasicStroke stroke = (BasicStroke)this.lineIcon.getStroke();
        this.lineIcon.setStroke(new BasicStroke(thickness, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase()));
        this.setXIcon((XIcon)this.lineIcon);
    }

    public Color getColor() {
        return this.getForeground();
    }

    public void setColor(Color color) {
        this.setForeground(color);
    }

    private static class Line2DIcon
    extends ShapeIcon {
        private Line2DIcon() {
        }

        public void setShape(Shape shape) {
            if (!(shape instanceof Line2D)) {
                throw new IllegalArgumentException("shape must be an instance of Line2D");
            }
            super.setShape(shape);
        }

        public Line2D getLine2D() {
            return (Line2D)this.getShape();
        }
    }
}

