/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.softsmithy.lib.swing.HorizontalAlignment;
import org.softsmithy.lib.swing.customizer.AbstractTextCustomizer;

public class JLabelCustomizer
extends AbstractTextCustomizer {
    public JLabelCustomizer() {
        this(new JLabel(""));
        this.initForDefaultLabel();
    }

    public JLabelCustomizer(JLabel label) {
        super(label);
    }

    public JLabelCustomizer(String text) {
        this(new JLabel(text));
        this.initForDefaultLabel();
    }

    private void initForDefaultLabel() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public String getText() {
        JLabel label = (JLabel)this.getComponent();
        return label != null ? label.getText() : "";
    }

    @Override
    public void setText(String text) {
        JLabel label = (JLabel)this.getComponent();
        if (label != null) {
            label.setText(text);
        }
    }

    @Override
    public void setComponent(JComponent component) {
        if (!(component instanceof JLabel)) {
            throw new IllegalArgumentException("comp must be a JLabel");
        }
        JLabel label = (JLabel)component;
        super.setComponent(label);
    }

    @Override
    protected void setHorizontalAlignmentOnly(HorizontalAlignment alignment) {
        JLabel label = (JLabel)this.getComponent();
        if (label != null) {
            label.setHorizontalAlignment(alignment.getSwingConstant());
        }
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        JLabel label = (JLabel)this.getComponent();
        return label != null ? HorizontalAlignment.getHorizontalAlignment((int)label.getHorizontalAlignment()) : HorizontalAlignment.getHorizontalAlignment((int)new JLabel().getHorizontalAlignment());
    }
}

