/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.softsmithy.lib.swing.customizer.AbstractCustomizer;
import org.softsmithy.lib.swing.customizer.JCustomizerPane;
import org.softsmithy.lib.swing.customizer.event.CustomizerEvent;
import org.softsmithy.lib.swing.customizer.event.CustomizerListener;
import org.softsmithy.lib.swing.customizer.state.StateManager;
import org.softsmithy.lib.swing.internal.TableLayout;
import org.softsmithy.lib.swing.internal.TableLayoutConstraints;

public class JCustomizer
extends AbstractCustomizer {
    private JComponent component;
    private final JPanel componentContainer = new JPanel();
    private final JPanel glassPane = new JPanel();
    private StateManager stateManager;
    private final Set<CustomizerListener> listeners = new HashSet<CustomizerListener>();
    private static final TableLayoutConstraints CONSTRAINTS = new TableLayoutConstraints();

    public JCustomizer() {
        this(new JPanel());
    }

    public JCustomizer(JComponent component) {
        this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0}, {-1.0}}));
        this.glassPane.setLayout(new BorderLayout());
        this.glassPane.setOpaque(false);
        this.add(this.glassPane, CONSTRAINTS);
        this.componentContainer.setLayout(new BorderLayout());
        this.componentContainer.setOpaque(false);
        this.add(this.componentContainer, CONSTRAINTS);
        this.setComponent(component);
        this.setStateManager(new StateManager(this));
        this.setRequestFocusEnabled(true);
        this.setCustomizableProperties(new LinkedHashSet<String>(Arrays.asList("x", "y", "width", "height")));
    }

    public JComponent getComponent() {
        return this.component;
    }

    private JPanel getComponentContainer() {
        return this.componentContainer;
    }

    public void setComponent(JComponent component) {
        if (this.component != null) {
            this.getComponentContainer().remove(this.component);
        }
        this.component = component;
        this.getComponentContainer().add((Component)component, "Center");
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    protected void setStateManager(StateManager manager) {
        if (this.stateManager != null) {
            this.glassPane.removeMouseListener(this.stateManager);
            this.glassPane.removeMouseMotionListener(this.stateManager);
            this.removeFocusListener(this.stateManager);
            this.stateManager.unconfigureCustomizer();
        }
        this.stateManager = manager;
        this.glassPane.addMouseListener(this.stateManager);
        this.glassPane.addMouseMotionListener(this.stateManager);
        this.addFocusListener(this.stateManager);
        this.stateManager.configureCustomizer();
    }

    public void reshapeRel(int dx, int dy, int dwidth, int dheight) {
        this.reshapeRelOnly(dx, dy, dwidth, dheight);
        this.fireCustomizerReshapeRel(new CustomizerEvent((Object)this, dx, dy, dwidth, dheight));
    }

    protected void reshapeRelOnly(int dx, int dy, int dwidth, int dheight) {
        this.getParentCustomizerPane().setAbsoluteCustomizerBounds(this, this.calculateBounds(dx, dy, dwidth, dheight));
        this.revalidate();
        this.doLayout();
        this.getComponentContainer().doLayout();
        this.repaint();
    }

    public void setBoundsRel(int dx, int dy, int dwidth, int dheight) {
        this.setBoundsRelOnly(dx, dy, dwidth, dheight);
        this.fireCustomizerResetBoundsRel(new CustomizerEvent((Object)this, dx, dy, dwidth, dheight));
    }

    protected void setBoundsRelOnly(int dx, int dy, int dwidth, int dheight) {
        Rectangle bounds = this.calculateBounds(dx, dy, dwidth, dheight);
        this.setBounds(bounds);
        this.doLayout();
        this.repaint();
    }

    private Rectangle calculateBounds(int dx, int dy, int dwidth, int dheight) {
        Rectangle bounds = this.getBounds();
        return new Rectangle(bounds.x + dx, bounds.y + dy, bounds.width + dwidth, bounds.height + dheight);
    }

    public void addCustomizerListener(CustomizerListener listener) {
        this.listeners.add(listener);
    }

    public void removeCustomizerListener(CustomizerListener listener) {
        this.listeners.remove(listener);
    }

    public void fireCustomizerResetBoundsRel(CustomizerEvent e) {
        Iterator<CustomizerListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().customizerResetBoundsRel(e);
        }
    }

    public void fireCustomizerReshapeRel(CustomizerEvent e) {
        Iterator<CustomizerListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().customizerReshapeRel(e);
        }
    }

    public JPanel getGlassPane() {
        return this.glassPane;
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (this.getGlassPane() != null) {
            this.getGlassPane().setToolTipText(text);
        }
        if (this.getComponent() != null) {
            this.getComponent().setToolTipText(text);
        }
    }

    public void applyBorder(Border border) {
        this.getGlassPane().setBorder(border);
        Insets insets = this.getGlassPane().getInsets();
        if (!insets.equals(this.getComponentContainer().getInsets())) {
            this.getComponentContainer().setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        }
    }

    public void setX(int x) {
        int oldValue = this.getX();
        this.reshapeRelOnly(x - this.getX(), 0, 0, 0);
        this.firePropertyChange("x", oldValue, this.getX());
    }

    public void setY(int y) {
        int oldValue = this.getY();
        this.reshapeRelOnly(0, y - this.getY(), 0, 0);
        this.firePropertyChange("y", oldValue, this.getY());
    }

    public void setWidth(int width) {
        int oldValue = this.getWidth();
        this.reshapeRelOnly(0, 0, width - this.getWidth(), 0);
        this.firePropertyChange("width", oldValue, this.getWidth());
    }

    public void setHeight(int height) {
        int oldValue = this.getX();
        this.reshapeRelOnly(0, 0, 0, height - this.getHeight());
        this.firePropertyChange("height", oldValue, this.getHeight());
    }

    public String getToolTipText() {
        return this.getComponent() != null ? this.getComponent().getToolTipText() : super.getToolTipText();
    }

    public void setDefaultBackground(Color bg) {
        super.setDefaultBackground(bg);
        if (this.getComponent() != null) {
            this.getComponent().setBackground(bg);
        }
    }

    public void setDefaultForeground(Color fg) {
        super.setDefaultForeground(fg);
        if (this.getComponent() != null) {
            this.getComponent().setForeground(fg);
        }
    }

    public void setDefaultFont(Font font) {
        super.setDefaultFont(font);
        if (this.getComponent() != null) {
            this.getComponent().setFont(font);
        }
    }

    public void setDefaultOpaque(boolean isOpaque) {
        super.setDefaultOpaque(isOpaque);
        if (this.getComponent() != null) {
            this.getComponent().setOpaque(isOpaque);
        }
    }

    public JCustomizerPane getParentCustomizerPane() {
        return (JCustomizerPane)((Object)this.getParent());
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public void fireActionEvent(ActionEvent ev) {
        ActionListener[] actionListeners = (ActionListener[])this.getListeners(ActionListener.class);
        for (int i = 0; i < actionListeners.length; ++i) {
            actionListeners[i].actionPerformed(ev);
        }
    }

    public Color getNormalBorderColor() {
        return this.getStateManager().getNormalBorderColor();
    }

    public Color getSelectedBorderColor() {
        return this.getStateManager().getSelectedBorderColor();
    }

    public boolean isUsingDefaultNormalBorderColor() {
        return this.getStateManager().isUsingDefaultNormalBorderColor();
    }

    public void setUsingDefaultNormalBorderColor(boolean usingDefaultNormalBorderColor) {
        this.getStateManager().setUsingDefaultNormalBorderColor(usingDefaultNormalBorderColor);
    }

    public boolean isUsingDefaultSelectedBorderColor() {
        return this.getStateManager().isUsingDefaultSelectedBorderColor();
    }

    public void setUsingDefaultSelectedBorderColor(boolean usingDefaultSelectedBorderColor) {
        this.getStateManager().setUsingDefaultSelectedBorderColor(usingDefaultSelectedBorderColor);
    }
}

