/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer.state;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.softsmithy.lib.swing.customizer.AbstractTextCustomizer;
import org.softsmithy.lib.swing.customizer.state.State;
import org.softsmithy.lib.swing.customizer.state.StateManager;

public class EditableStateManager
extends StateManager {
    private final State editableState;
    private final EditableListener editableListener = new EditableListener();

    public EditableStateManager(AbstractTextCustomizer customizer) {
        super(customizer);
        this.editableState = new EditableState(customizer);
    }

    public State getEditableState() {
        return this.editableState;
    }

    public void setStateEditable() {
        this.setState(this.getEditableState());
    }

    public AbstractTextCustomizer getTextCustomizer() {
        return (AbstractTextCustomizer)this.getCustomizer();
    }

    @Override
    public void configureCustomizer() {
        super.configureCustomizer();
        this.getCustomizer().addActionListener(this.editableListener);
    }

    @Override
    public void unconfigureCustomizer() {
        this.getCustomizer().removeActionListener(this.editableListener);
        super.unconfigureCustomizer();
    }

    private static class EditableState
    extends StateManager.DefaultState {
        private Component component = null;

        public EditableState(AbstractTextCustomizer customizer) {
            super(customizer);
        }

        @Override
        public void applyCursor() {
            this.getCustomizer().setCursor(null);
        }

        @Override
        public void configureCustomizer() {
            super.configureCustomizer();
            JTextComponent editor = ((AbstractTextCustomizer)this.getCustomizer()).getEditor();
            editor.setText(((AbstractTextCustomizer)this.getCustomizer()).getText());
            this.component = editor;
            if (((AbstractTextCustomizer)this.getCustomizer()).isEditorScrollable()) {
                this.component = new JScrollPane(editor);
            }
            this.getCustomizer().getGlassPane().add(this.component, "Center");
            this.getCustomizer().getGlassPane().revalidate();
            if (!editor.hasFocus()) {
                editor.requestFocus();
            }
        }

        @Override
        public void unconfigureCustomizer() {
            JTextComponent editor = ((AbstractTextCustomizer)this.getCustomizer()).getEditor();
            this.getCustomizer().getGlassPane().remove(this.component);
            ((AbstractTextCustomizer)this.getCustomizer()).setText(editor.getText());
            this.getCustomizer().repaint();
            super.unconfigureCustomizer();
        }
    }

    private class EditableListener
    implements ActionListener {
        private EditableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (EditableStateManager.this.getTextCustomizer().isEditable()) {
                EditableStateManager.this.setStateEditable();
            }
        }
    }
}

