/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.softsmithy.lib.awt.AWTUtilities;
import org.softsmithy.lib.math.BigIntegers;
import org.softsmithy.lib.swing.customizer.layout.AbstractTableLayout;
import org.softsmithy.lib.swing.customizer.layout.CustomizerConstraints;
import org.softsmithy.lib.swing.customizer.layout.TableConstraints;

public class InfiniteTableLayout
extends AbstractTableLayout {
    private Map<Component, TableConstraints> constraints = new HashMap<Component, TableConstraints>();
    private final InfiniteAxis columns;
    private final InfiniteAxis rows;
    private Dimension occupiedDimension = new Dimension(0, 0);
    private final Container parent;
    private final Map<Component, Integer> compHeights = new HashMap<Component, Integer>();
    private final SortedSet<Component> sortedCompHeights = new TreeSet<Component>(new CompHeightsComparator());
    private final Map<Component, Integer> compWidths = new HashMap<Component, Integer>();
    private final SortedSet<Component> sortedCompWidths = new TreeSet<Component>(new CompWidthsComparator());

    public InfiniteTableLayout(int defaultColumnWidth, int defaultRowHeight, Container parent) {
        this.columns = new InfiniteAxis(defaultColumnWidth){

            @Override
            public void drawLine(int startPixel, int endPixel, int offset, Graphics g) {
                g.drawLine(offset, startPixel, offset, endPixel);
            }
        };
        this.rows = new InfiniteAxis(defaultRowHeight){

            @Override
            public void drawLine(int startPixel, int endPixel, int offset, Graphics g) {
                g.drawLine(startPixel, offset, endPixel, offset);
            }
        };
        this.ensureValidity(parent);
        this.parent = parent;
    }

    public InfiniteTableLayout(Container parent) {
        this(10, 10, parent);
    }

    public Container getParent() {
        return this.parent;
    }

    @Override
    public void setColumnWidth(int column, double width) {
        this.columns.setSize(column, (int)width);
    }

    @Override
    public double getColumnWidth(int column) {
        return this.columns.getSize(column);
    }

    public void makeColumnDefault(int column) {
        this.columns.makeDefault(column);
    }

    public boolean isDefaultColumn(int column) {
        return this.columns.isDefault(column);
    }

    @Override
    public void setRowHeight(int row, double height) {
        this.rows.setSize(row, (int)height);
    }

    @Override
    public double getRowHeight(int row) {
        return this.rows.getSize(row);
    }

    public void makeRowDefault(int row) {
        this.rows.makeDefault(row);
    }

    public boolean isDefaultRow(int row) {
        return this.rows.isDefault(row);
    }

    public int getDefaultColumnWidth() {
        return this.columns.getDefaultSize();
    }

    public void setDefaultColumnWidth(int defaultColumnWidth, boolean absolute) {
        Map<Component, Rectangle> bounds = this.getBounds(absolute);
        this.columns.setDefaultSize(defaultColumnWidth);
        this.setBounds(bounds, absolute);
    }

    public int getDefaultRowHeight() {
        return this.rows.getDefaultSize();
    }

    public void setDefaultRowHeight(int defaultRowHeight, boolean absolute) {
        Map<Component, Rectangle> bounds = this.getBounds(absolute);
        this.rows.setDefaultSize(defaultRowHeight);
        this.setBounds(bounds, absolute);
    }

    @Override
    public TableConstraints getTableConstraints(Component comp) {
        return this.constraints.get(comp);
    }

    @Override
    public CustomizerConstraints getCustomizerConstraints(Component comp) {
        return this.getTableConstraints(comp);
    }

    @Override
    public void setTableConstraints(Component comp, TableConstraints tc) {
        this.constraints.put(comp, tc);
        int preferredWidth = this.getRightPosition(comp);
        if (this.sortedCompWidths.contains(comp)) {
            this.sortedCompWidths.remove(comp);
        }
        this.compWidths.put(comp, preferredWidth);
        this.sortedCompWidths.add(comp);
        int preferredHeight = this.getBottomPosition(comp);
        if (this.sortedCompHeights.contains(comp)) {
            this.sortedCompHeights.remove(comp);
        }
        this.compHeights.put(comp, preferredHeight);
        this.sortedCompHeights.add(comp);
        this.resetOccupiedDimension();
    }

    @Override
    public void setCustomizerConstraints(Component comp, CustomizerConstraints cc) {
        if (!(cc instanceof TableConstraints)) {
            throw new IllegalArgumentException("CustomizerConstraints must be an instance of TableConstraints!");
        }
        this.setTableConstraints(comp, (TableConstraints)cc);
    }

    private int getRightPosition(Component comp) {
        TableConstraints tc = this.constraints.get(comp);
        BigInteger rightPosition = BigInteger.valueOf(tc.getX()).add(BigInteger.valueOf(tc.getWidth()));
        rightPosition = rightPosition.min(BigIntegers.MAX_INTEGER);
        return rightPosition.intValue();
    }

    private int getBottomPosition(Component comp) {
        TableConstraints tc = this.constraints.get(comp);
        BigInteger leftPosition = BigInteger.valueOf(tc.getY()).add(BigInteger.valueOf(tc.getHeight()));
        leftPosition = leftPosition.min(BigIntegers.MAX_INTEGER);
        return leftPosition.intValue();
    }

    private void resetOccupiedDimension() {
        this.occupiedDimension.width = this.sortedCompWidths.isEmpty() ? 0 : this.compWidths.get(this.sortedCompWidths.last());
        this.occupiedDimension.height = this.sortedCompHeights.isEmpty() ? 0 : this.compHeights.get(this.sortedCompHeights.last());
    }

    @Override
    public void deleteColumn(int i, boolean absolute) {
        Map<Component, Rectangle> bounds = this.getBounds(absolute);
        this.columns.delete(i);
        this.setBounds(bounds, absolute);
    }

    @Override
    public void deleteRow(int i, boolean absolute) {
        Map<Component, Rectangle> bounds = this.getBounds(absolute);
        this.rows.delete(i);
        this.setBounds(bounds, absolute);
    }

    @Override
    public void drawGrid(Container container, Graphics g) {
        Rectangle innerArea = AWTUtilities.calculateInnerArea((Container)container, null);
        this.ensureValidity(innerArea);
        this.columns.draw(innerArea.y, innerArea.height, g);
        this.rows.draw(innerArea.x, innerArea.width, g);
    }

    @Override
    public void drawLayoutHelp(Container container, Graphics g) {
        this.drawGrid(container, g);
    }

    @Override
    public void insertColumn(int i, boolean absolute) {
        Map<Component, Rectangle> bounds = this.getBounds(absolute);
        this.columns.insert(i);
        this.setBounds(bounds, absolute);
    }

    @Override
    public void insertRow(int i, boolean absolute) {
        Map<Component, Rectangle> bounds = this.getBounds(absolute);
        this.rows.insert(i);
        this.setBounds(bounds, absolute);
    }

    private Map<Component, Rectangle> getBounds(boolean absolute) {
        Map<Component, Rectangle> bounds = absolute ? this.getAbsoluteBounds() : this.getRelativeBounds();
        return bounds;
    }

    private void setBounds(Map<Component, Rectangle> bounds, boolean absolute) {
        if (absolute) {
            this.setAbsoluteBounds(bounds);
        } else {
            this.setRelativeBounds(bounds);
        }
    }

    private Map<Component, Rectangle> getAbsoluteBounds() {
        HashMap<Component, Rectangle> bounds = new HashMap<Component, Rectangle>();
        Component[] components = this.getComponents(this.parent);
        for (int i = 0; i < components.length; ++i) {
            bounds.put(components[i], this.getTableConstraints(components[i]).getAbsoluteBounds());
        }
        return bounds;
    }

    private Map<Component, Rectangle> getRelativeBounds() {
        HashMap<Component, Rectangle> bounds = new HashMap<Component, Rectangle>();
        Component[] components = this.getComponents(this.parent);
        for (int i = 0; i < components.length; ++i) {
            bounds.put(components[i], this.getTableConstraints(components[i]).getRelativeBounds());
        }
        return bounds;
    }

    private void setAbsoluteBounds(Map<Component, Rectangle> bounds) {
        Component[] components = this.getComponents(this.parent);
        for (int i = 0; i < components.length; ++i) {
            this.setAbsoluteBounds(components[i], bounds.get(components[i]));
        }
    }

    private void setRelativeBounds(Map<Component, Rectangle> bounds) {
        Component[] components = this.getComponents(this.parent);
        for (int i = 0; i < components.length; ++i) {
            this.setRelativeBounds(components[i], bounds.get(components[i]));
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.occupiedDimension);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
        this.sortedCompWidths.remove(comp);
        this.compWidths.remove(comp);
        this.sortedCompHeights.remove(comp);
        this.compHeights.remove(comp);
        this.resetOccupiedDimension();
    }

    @Override
    public int columnIndex(int pixel) {
        return this.columns.offsetIndex(pixel);
    }

    @Override
    public int rowIndex(int pixel) {
        return this.rows.offsetIndex(pixel);
    }

    @Override
    public int colSpan(int fromIndex, int pixelWidth) {
        return this.columns.offsetSpan(fromIndex, pixelWidth);
    }

    @Override
    public int rowSpan(int fromIndex, int pixelHeight) {
        return this.rows.offsetSpan(fromIndex, pixelHeight);
    }

    @Override
    public int width(int fromIndex, int colSpan) {
        return this.columns.size(fromIndex, colSpan);
    }

    @Override
    public int height(int fromIndex, int rowSpan) {
        return this.rows.size(fromIndex, rowSpan);
    }

    @Override
    public int yLocation(int index) {
        return this.rows.location(index);
    }

    @Override
    public int xLocation(int index) {
        return this.columns.location(index);
    }

    @Override
    public int adjustX(int pixel) {
        this.ensureValidity(this.parent);
        return this.columns.location(this.columns.offsetIndex(pixel));
    }

    @Override
    public int adjustY(int pixel) {
        this.ensureValidity(this.parent);
        return this.rows.location(this.rows.offsetIndex(pixel));
    }

    @Override
    public int adjustWidth(int xPixel, int pixelWidth) {
        this.ensureValidity(this.parent);
        int xIndex = this.columns.index(xPixel);
        return this.columns.size(xIndex, this.columns.span(xIndex, pixelWidth));
    }

    @Override
    public int adjustHeight(int yPixel, int pixelHeight) {
        this.ensureValidity(this.parent);
        int yIndex = this.rows.index(yPixel);
        return this.rows.size(yIndex, this.rows.span(yIndex, pixelHeight));
    }

    @Override
    public Rectangle adjustBounds(Rectangle bounds) {
        this.ensureValidity(this.parent);
        int xIndex = this.columns.index(bounds.x);
        int yIndex = this.rows.index(bounds.y);
        bounds.x = this.columns.location(xIndex);
        bounds.y = this.rows.location(yIndex);
        bounds.width = this.columns.size(xIndex, this.columns.span(xIndex, bounds.width));
        bounds.height = this.rows.size(yIndex, this.rows.span(yIndex, bounds.height));
        return bounds;
    }

    @Override
    protected AbstractTableLayout.AbstractAxis getColumns() {
        return this.columns;
    }

    @Override
    protected AbstractTableLayout.AbstractAxis getRows() {
        return this.rows;
    }

    @Override
    public void setAbsoluteBounds(Component component, Rectangle bounds) {
        TableConstraints tc = this.getTableConstraints(component);
        if (tc != null) {
            tc.setAbsoluteBounds(bounds);
            this.setTableConstraints(component, tc);
            this.layoutComponent(this.getParent(), component);
        }
    }

    @Override
    public void setRelativeBounds(Component component, Rectangle bounds) {
        TableConstraints tc = this.getTableConstraints(component);
        if (tc != null) {
            tc.setRelativeBounds(bounds);
            this.setTableConstraints(component, tc);
            this.layoutComponent(this.getParent(), component);
        }
    }

    private class CompWidthsComparator
    implements Comparator<Component> {
        private CompWidthsComparator() {
        }

        @Override
        public int compare(Component comp1, Component comp2) {
            Integer rightPosition1 = InfiniteTableLayout.this.compWidths.containsKey(comp1) ? (Integer)InfiniteTableLayout.this.compWidths.get(comp1) : InfiniteTableLayout.this.getRightPosition(comp1);
            Integer rightPosition2 = InfiniteTableLayout.this.compWidths.containsKey(comp2) ? (Integer)InfiniteTableLayout.this.compWidths.get(comp2) : InfiniteTableLayout.this.getRightPosition(comp2);
            return rightPosition1.compareTo(rightPosition2);
        }
    }

    private class CompHeightsComparator
    implements Comparator<Component> {
        private CompHeightsComparator() {
        }

        @Override
        public int compare(Component comp1, Component comp2) {
            Integer bottomPosition1 = InfiniteTableLayout.this.compHeights.containsKey(comp1) ? (Integer)InfiniteTableLayout.this.compHeights.get(comp1) : InfiniteTableLayout.this.getBottomPosition(comp1);
            Integer bottomPosition2 = InfiniteTableLayout.this.compHeights.containsKey(comp2) ? (Integer)InfiniteTableLayout.this.compHeights.get(comp2) : InfiniteTableLayout.this.getBottomPosition(comp2);
            return bottomPosition1.compareTo(bottomPosition2);
        }
    }

    private static abstract class InfiniteAxis
    extends AbstractTableLayout.AbstractAxis {
        private int defaultSize;
        private SortedMap<Integer, Integer> sizes = new TreeMap<Integer, Integer>();
        private List<Integer> offsets = new ArrayList<Integer>();

        public InfiniteAxis(int defaultSize) {
            this.defaultSize = defaultSize;
        }

        public int getDefaultSize() {
            return this.defaultSize;
        }

        public void setDefaultSize(int defaultSize) {
            this.defaultSize = defaultSize;
            this.invalidate();
        }

        public int getSize(int index) {
            Integer size = (Integer)this.sizes.get(index);
            return size != null ? size.intValue() : this.getDefaultSize();
        }

        public void setSize(int index, int size) {
            this.sizes.put(index, size);
            this.invalidate();
        }

        public void makeDefault(int index) {
            this.sizes.remove(index);
            this.invalidate();
        }

        public boolean isDefault(int index) {
            return !this.sizes.containsKey(index);
        }

        public void delete(int index) {
            Integer i = index;
            if (this.sizes.containsKey(i)) {
                this.sizes.remove(i);
            }
            for (Integer j : new TreeMap<Integer, Integer>(this.sizes.tailMap(i)).keySet()) {
                this.sizes.put(j - 1, (Integer)this.sizes.get(j));
                this.sizes.remove(j);
            }
            this.invalidate();
        }

        public void insert(int index) {
            Integer i = index;
            TreeMap map = new TreeMap();
            for (Integer j : new TreeMap<Integer, Integer>(this.sizes.tailMap(i)).keySet()) {
                map.put(j + 1, this.sizes.get(j));
                this.sizes.remove(j);
            }
            this.sizes.putAll(map);
            this.invalidate();
        }

        @Override
        public void calculateOffsets(int start, int length) {
            this.offsets.clear();
            this.offsets.add(start);
            int availableLength = length;
            int i = 0;
            while (availableLength > 0) {
                int size = this.getSize(i);
                if (size < availableLength) {
                    this.offsets.add(this.offsets.get(i) + size);
                }
                availableLength -= size;
                ++i;
            }
        }

        public int getOffset(int index) {
            int offset = -1;
            if (index < this.offsets.size()) {
                offset = this.offsets.get(index);
            }
            return offset;
        }

        public int location(int index) {
            BigInteger location;
            if (index < this.offsets.size()) {
                location = BigInteger.valueOf(this.getOffset(index));
            } else {
                location = BigInteger.valueOf(this.getOffset(this.offsets.size() - 1));
                for (int i = this.offsets.size(); i <= index; ++i) {
                    location = location.add(BigInteger.valueOf(this.getSize(i)));
                }
            }
            return location.min(BigIntegers.MAX_INTEGER).intValue();
        }

        public int offsetIndex(int pixel) {
            int index = this.offsets.size();
            for (int i = 0; i < this.offsets.size(); ++i) {
                if (pixel > this.getOffset(i) + this.getSize(i) / 2) continue;
                index = i;
                break;
            }
            return index;
        }

        public int index(int pixel) {
            int index;
            if (pixel < this.getOffset(this.offsets.size() - 1) + this.getSize(this.offsets.size() - 1) / 2) {
                index = this.offsetIndex(pixel);
            } else {
                int i = this.offsets.size();
                int offset = this.getOffset(this.offsets.size() - 1) + this.getSize(this.offsets.size() - 1);
                while (pixel > offset + this.getSize(i) / 2) {
                    offset += this.getSize(i);
                    ++i;
                }
                index = i;
            }
            return index;
        }

        public int offsetSpan(int fromIndex, int pixelSize) {
            int span = 1;
            for (int i = fromIndex; i < this.offsets.size(); ++i) {
                if (pixelSize > this.getOffset(i) + this.getSize(i) / 2 - this.getOffset(fromIndex)) continue;
                span = i - fromIndex;
                break;
            }
            if (span < 1) {
                span = 1;
            }
            return span;
        }

        public int span(int fromIndex, int pixelSize) {
            int lastIndex = this.offsets.size() - 1;
            BigInteger fromLocation = BigInteger.valueOf(this.location(fromIndex));
            int span = 0;
            BigInteger pSize = BigInteger.valueOf(pixelSize);
            int i = fromIndex;
            while (pSize.compareTo(BigInteger.valueOf(this.location(i)).add(BigInteger.valueOf(this.getSize(i) / 2)).subtract(fromLocation)) > 0) {
                ++span;
                ++i;
            }
            if (span < 1) {
                span = 1;
            }
            return span;
        }

        public int size(int fromIndex, int span) {
            BigInteger size = BigInteger.ZERO;
            int toIndex = span + fromIndex;
            for (int i = fromIndex; i < toIndex; ++i) {
                size = size.add(BigInteger.valueOf(this.getSize(i)));
            }
            return size.min(BigIntegers.MAX_INTEGER).intValue();
        }

        @Override
        protected void calculateSizes(int innerSize) {
        }

        public void draw(int startPixel, int pixelSize, Graphics g) {
            int endPixel = startPixel + pixelSize - 1;
            for (int i = 0; i < this.offsets.size(); ++i) {
                int offset = this.getOffset(i);
                this.drawLine(startPixel, endPixel, offset, g);
            }
        }

        protected abstract void drawLine(int var1, int var2, int var3, Graphics var4);
    }
}

