/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer.action;

import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import org.softsmithy.lib.swing.customizer.JCustomizer;
import org.softsmithy.lib.swing.customizer.SelectionManager;

public class CustomizerItemListenerProvider {
    private SelectionManager selectionManager;
    private ItemListener textBold = null;
    private ItemListener textItalic = null;

    public CustomizerItemListenerProvider(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public ItemListener getTextBoldItemListener() {
        if (this.textBold == null) {
            this.textBold = new TextBoldItemListener();
        }
        return this.textBold;
    }

    public ItemListener getTextItalicItemListener() {
        if (this.textItalic == null) {
            this.textItalic = new TextItalicItemListener();
        }
        return this.textItalic;
    }

    private abstract class CustomizerItemListener
    implements ItemListener {
        private String propertyName;

        public CustomizerItemListener(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object newPropertyValue = this.calculatePropertyValue(e);
            if (this.propertyReallyChanged(newPropertyValue)) {
                this.setProperty(newPropertyValue);
            }
        }

        protected abstract Object calculatePropertyValue(ItemEvent var1);

        protected abstract void setProperty(Object var1);

        protected abstract Object getProperty();

        private boolean propertyReallyChanged(Object newPropertyValue) {
            return this.notJustSelectionChanged() && this.isAllowedToChange() && this.isNoDriggeredChange(newPropertyValue);
        }

        private boolean notJustSelectionChanged() {
            return !CustomizerItemListenerProvider.this.selectionManager.isFireingSelectionChanged();
        }

        private boolean isAllowedToChange() {
            return JCustomizer.getCommonCustomizableProperties(Arrays.asList(CustomizerItemListenerProvider.this.selectionManager.getSelectedCustomizers())).contains(this.getPropertyName());
        }

        private boolean isNoDriggeredChange(Object newPropertyValue) {
            return !this.getProperty().equals(newPropertyValue);
        }
    }

    private abstract class FontStyleItemListener
    extends CustomizerItemListener {
        public FontStyleItemListener() {
            super("font");
        }

        @Override
        protected Object getProperty() {
            Integer property = null;
            if (CustomizerItemListenerProvider.this.selectionManager.getActiveCustomizer() != null) {
                Font font = CustomizerItemListenerProvider.this.selectionManager.getActiveCustomizer().getFont();
                int style = font.getStyle();
                property = new Integer(style);
            }
            return property;
        }

        @Override
        protected void setProperty(Object value) {
            int style = (Integer)value;
            JCustomizer[] customizers = CustomizerItemListenerProvider.this.selectionManager.getSelectedCustomizers();
            for (int i = 0; i < customizers.length; ++i) {
                Font font = customizers[i].getFont();
                customizers[i].setFont(font.deriveFont(style));
            }
        }

        @Override
        protected Object calculatePropertyValue(ItemEvent e) {
            int style = 0;
            if (CustomizerItemListenerProvider.this.selectionManager.getActiveCustomizer() != null) {
                Font font = CustomizerItemListenerProvider.this.selectionManager.getActiveCustomizer().getFont();
                style = this.calculateFontStyle(e, font);
            }
            return new Integer(style);
        }

        protected abstract int calculateFontStyle(ItemEvent var1, Font var2);
    }

    private class TextItalicItemListener
    extends FontStyleItemListener {
        private TextItalicItemListener() {
        }

        @Override
        protected int calculateFontStyle(ItemEvent e, Font font) {
            int style;
            if (e.getStateChange() == 1) {
                style = 2;
                if (font.isBold()) {
                    style |= 1;
                }
            } else {
                style = font.isBold() ? 1 : 0;
            }
            return style;
        }
    }

    private class TextBoldItemListener
    extends FontStyleItemListener {
        private TextBoldItemListener() {
        }

        @Override
        protected int calculateFontStyle(ItemEvent e, Font font) {
            int style;
            if (e.getStateChange() == 1) {
                style = 1;
                if (font.isItalic()) {
                    style |= 2;
                }
            } else {
                style = font.isItalic() ? 2 : 0;
            }
            return style;
        }
    }
}

