/*
 * Decompiled with CFR 0.152.
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import org.softsmithy.lib.awt.event.ComponentLayoutListener;
import org.softsmithy.lib.swing.customizer.AbstractCustomizer;
import org.softsmithy.lib.swing.customizer.CustomizerBar;
import org.softsmithy.lib.swing.customizer.JCustomizer;
import org.softsmithy.lib.swing.customizer.SelectionManager;
import org.softsmithy.lib.swing.customizer.layout.CustomizerConstraints;
import org.softsmithy.lib.swing.customizer.layout.CustomizerLayout;
import org.softsmithy.lib.swing.customizer.layout.InfiniteTableLayout;

public class JCustomizerPane
extends AbstractCustomizer
implements MouseListener {
    private boolean showingLayoutHelp = true;
    private SelectionManager selectionManager = new SelectionManager();
    private CustomizerBar customizerBar;
    private boolean active = false;
    private boolean inited = false;
    private boolean activationBorderEnabled = false;
    private Color activeBorderColor = Color.GREEN;
    private Color inactiveBorderColor = Color.LIGHT_GRAY;
    private Color layoutHelpColor = Color.LIGHT_GRAY;
    private Color defaultNormalCustomizerBorderColor = Color.GRAY;
    private Color defaultSelectedCustomizerBorderColor = Color.BLUE;

    public JCustomizerPane() {
        this.initComponents();
        this.inited = true;
        this.setLayout(new InfiniteTableLayout((Container)((Object)this)));
        this.setSize(400, 300);
        this.addMouseListener(this);
        this.setBackground(Color.WHITE);
    }

    private void initComponents() {
        this.setLayout(null);
    }

    public boolean isShowingLayoutHelp() {
        return this.showingLayoutHelp;
    }

    public void setShowingLayoutHelp(boolean showingLayoutHelp) {
        this.showingLayoutHelp = showingLayoutHelp;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isShowingLayoutHelp()) {
            Color oldColor = g.getColor();
            g.setColor(this.getLayoutHelpColor());
            this.getCustomizerLayout().drawLayoutHelp((Container)((Object)this), g);
            g.setColor(oldColor);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.hasFocus()) {
            this.requestFocus();
            this.getSelectionManager().clearSelection();
        }
        if (this.customizerBar != null && this.customizerBar.hasSelection()) {
            this.customizerBar.consumeSelection(this, e.getPoint());
        }
    }

    public CustomizerBar getCustomizerBar() {
        return this.customizerBar;
    }

    public void setCustomizerBar(CustomizerBar customizerBar) {
        this.customizerBar = customizerBar;
    }

    public void setSelectionManager(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public JCustomizer[] getCustomizers() {
        return Arrays.asList(this.getComponents()).toArray(new JCustomizer[this.getComponents().length]);
    }

    public JCustomizer[] getIntersectedCustomizers(Rectangle2D rectangle) {
        ArrayList<JCustomizer> customizers = new ArrayList<JCustomizer>();
        JCustomizer[] allCustomizers = this.getCustomizers();
        for (int i = 0; i < allCustomizers.length; ++i) {
            if (!allCustomizers[i].getBounds().intersects(rectangle)) continue;
            customizers.add(allCustomizers[i]);
        }
        return customizers.toArray(new JCustomizer[customizers.size()]);
    }

    public void setLayout(LayoutManager mgr) {
        if (this.inited && !(mgr instanceof CustomizerLayout)) {
            throw new IllegalArgumentException("mgr must be an instance of CustomizerLayout!");
        }
        super.setLayout(mgr);
    }

    public void setCustomizerLayout(CustomizerLayout cl) {
        this.setLayout(cl);
    }

    public CustomizerLayout getCustomizerLayout() {
        return (CustomizerLayout)this.getLayout();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof JCustomizer)) {
            throw new IllegalArgumentException("comp must be an instance of JCustomizer!");
        }
        if (!(constraints instanceof CustomizerConstraints)) {
            throw new IllegalArgumentException("constraints must be an instance of CustomizerConstraints!");
        }
        super.addImpl(comp, constraints, index);
    }

    public void addCustomizer(JCustomizer customizer, CustomizerConstraints constraints) {
        this.add((Component)((Object)customizer), constraints);
    }

    public void setAbsoluteCustomizerBounds(JCustomizer customizer, Rectangle bounds) {
        this.getCustomizerLayout().setAbsoluteBounds((Component)((Object)customizer), bounds);
    }

    public void addComponentLayoutListener(ComponentLayoutListener listener) {
        this.getCustomizerLayout().addComponentLayoutListener(listener);
    }

    public void addComponentLayoutListener(Component component, ComponentLayoutListener listener) {
        this.getCustomizerLayout().addComponentLayoutListener(component, listener);
    }

    public void removeComponentLayoutListener(ComponentLayoutListener listener) {
        this.getCustomizerLayout().removeComponentLayoutListener(listener);
    }

    public void removeComponentLayoutListener(Component component, ComponentLayoutListener listener) {
        this.getCustomizerLayout().removeComponentLayoutListener(component, listener);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (active != this.isActive()) {
            boolean oldActive = this.isActive();
            this.active = active;
            if (this.isActivationBorderEnabled()) {
                this.setActivationBorder();
            }
            this.firePropertyChange("active", oldActive, active);
        }
    }

    public boolean isActivationBorderEnabled() {
        return this.activationBorderEnabled;
    }

    public void setActivationBorderEnabled(boolean activationBorderEnabled) {
        this.activationBorderEnabled = activationBorderEnabled;
        if (activationBorderEnabled) {
            this.setActivationBorder();
        }
    }

    public Color getActiveBorderColor() {
        return this.activeBorderColor;
    }

    public void setActiveBorderColor(Color activeBorderColor) {
        this.activeBorderColor = activeBorderColor;
        if (this.isActivationBorderEnabled()) {
            this.setActivationBorder();
        }
    }

    public Color getInactiveBorderColor() {
        return this.inactiveBorderColor;
    }

    public void setInactiveBorderColor(Color inactiveBorderColor) {
        this.inactiveBorderColor = inactiveBorderColor;
        if (this.isActivationBorderEnabled()) {
            this.setActivationBorder();
        }
    }

    private void setActivationBorder() {
        if (this.isActive()) {
            this.setBorder(BorderFactory.createLineBorder(this.getActiveBorderColor()));
        } else {
            this.setBorder(BorderFactory.createLineBorder(this.getInactiveBorderColor()));
        }
    }

    public Color getLayoutHelpColor() {
        return this.layoutHelpColor;
    }

    public void setLayoutHelpColor(Color layoutHelpColor) {
        this.layoutHelpColor = layoutHelpColor;
        this.repaint();
    }

    public Color getDefaultNormalCustomizerBorderColor() {
        return this.defaultNormalCustomizerBorderColor;
    }

    public void setDefaultNormalCustomizerBorderColor(Color defaultNormalCustomizerBorderColor) {
        Color oldDefaultNormalCustomizerBorderColor = this.defaultNormalCustomizerBorderColor;
        this.defaultNormalCustomizerBorderColor = defaultNormalCustomizerBorderColor;
        this.firePropertyChange("defaultNormalCustomizerBorderColor", oldDefaultNormalCustomizerBorderColor, defaultNormalCustomizerBorderColor);
    }

    public Color getDefaultSelectedCustomizerBorderColor() {
        return this.defaultSelectedCustomizerBorderColor;
    }

    public void setDefaultSelectedCustomizerBorderColor(Color defaultSelectedCustomizerBorderColor) {
        Color oldDefaultSelectedCustomizerBorderColor = this.defaultSelectedCustomizerBorderColor;
        this.defaultSelectedCustomizerBorderColor = defaultSelectedCustomizerBorderColor;
        this.firePropertyChange("defaultSelectedCustomizerBorderColor", oldDefaultSelectedCustomizerBorderColor, defaultSelectedCustomizerBorderColor);
    }
}

