/*
 *         COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL) Notice
 *
 * The contents of this file are subject to the COMMON DEVELOPMENT AND DISTRIBUTION LICENSE (CDDL)
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.opensource.org/licenses/cddl1.txt
 *
 * The Original Code is SoftSmithy Utility Library. The Initial Developer of the
 * Original Code is Florian Brunner (Sourceforge.net user: puce). All Rights Reserved.
 *
 * Contributor(s): .
 */

/*
 * CustomizerBarTabPane.java
 *
 * Created on 12. September 2002, 12:19
 */
package org.softsmithy.lib.swing.customizer;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;
import org.softsmithy.lib.swing.JXTable;

/**
 *
 * @author  puce
 */
public abstract class JTableCustomizerBar extends JPanel implements CustomizerBar {

    /** Creates new form CustomizerBarTabPane */
    public JTableCustomizerBar(TableModel tm) {
        initComponents();
        table = new JXTable(tm);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        scrollPane = new JScrollPane(table);
        add(BorderLayout.CENTER, scrollPane);
        table.setShowGrid(false);
    }

    /** Creates new form CustomizerBarTabPane */
    public JTableCustomizerBar(TableModel tm, int rowHeight) {
        this(tm);
        table.setRowHeight(rowHeight + table.getRowMargin());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.BorderLayout());
    }// </editor-fold>//GEN-END:initComponents

    public void clearSelection() {
        table.clearSelection();
    }

    public boolean hasSelection() {
        return table.getSelectedRowCount() > 0;
    }

    public int getSelection() {
        return table.getSelectedRow();
    }

    public TableModel getTableModel() {
        return table.getModel();
    }

    public int getRowHeight() {
        return table.getRowHeight();
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    private JTable table;
    private JScrollPane scrollPane;
}
