/*
 * Decompiled with CFR 0.152.
 */
package com.cognitivemedicine.config.utils;

import com.cognitivemedicine.config.utils.ConfigurationException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtils.class);
    private static Map<String, ConfigUtils> INSTANCES = Collections.synchronizedMap(new HashMap());
    private final Configuration baseConfiguration;
    private static String commonDirectory = null;

    public static String getCommonDirectory() {
        return commonDirectory;
    }

    public static void setCommonDirectory(String directory) {
        commonDirectory = directory;
    }

    private static void defaultCommonDirectory() {
        Path path;
        String definedEnv = System.getProperty("com.cognitivemedicine.config.commondirectory");
        if (definedEnv != null) {
            path = Paths.get(definedEnv, new String[0]);
            LOG.debug("Using common configuration directory specified by system propety com.cognitivemedicine.config.commondirectory");
        } else {
            definedEnv = System.getenv("com_cognitivemedicine_config_commondirectory");
            if (definedEnv != null) {
                path = Paths.get(definedEnv, new String[0]);
                LOG.debug("Using common configuration directory specified by environment variable com.cognitivemedicine.config.commondirectory");
            } else {
                String home = System.getProperty("user.home");
                path = Paths.get(home, "cognitivemedicine", "config");
                LOG.debug("Using default common configuration directory");
            }
        }
        commonDirectory = path.toString();
        LOG.debug("Common configuration directory is " + commonDirectory);
        if (!Files.exists(path, new LinkOption[0])) {
            LOG.info("Configuration common directory [" + commonDirectory + "] does not exist");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized ConfigUtils getInstance(String context) {
        ConfigUtils.LOG.debug("Retrieving configurations for context '{}'.", (Object)context);
        conf = ConfigUtils.INSTANCES.get(context);
        if (ConfigUtils.commonDirectory == null) {
            ConfigUtils.defaultCommonDirectory();
        }
        if (conf == null) {
            ConfigUtils.LOG.debug("Configuration for context '{}' is not yet loaded.", (Object)context);
            ConfigUtils.LOG.debug("Looking for any configuration property for context '{}' in the environment variables.", (Object)context);
            environmentConfiguration = new EnvironmentConfiguration().subset(context);
            if (ConfigUtils.LOG.isTraceEnabled()) {
                iterable = (Iterable<T>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$getInstance$0(org.apache.commons.configuration.Configuration ), ()Ljava/util/Iterator;)((Configuration)environmentConfiguration);
                size = StreamSupport.stream(iterable.spliterator(), false).count();
                ConfigUtils.LOG.debug("{} configuration properties found in the environmental variables for context '{}'.", (Object)size, (Object)context);
            }
            commonProperties = null;
            commonFile = Paths.get(ConfigUtils.commonDirectory, new String[]{context + ".properties"});
            if (Files.exists(commonFile, new LinkOption[0])) {
                try {
                    commonProperties = new PropertiesConfiguration(commonFile.toFile());
                }
                catch (org.apache.commons.configuration.ConfigurationException ex) {
                    errorMessage = String.format("Exception loading common configuration properties for context '%s' from %s: %s", new Object[]{context, commonFile, ex.getMessage()});
                    ConfigUtils.LOG.error(errorMessage, (Throwable)ex);
                    throw new ConfigurationException(errorMessage);
                }
                if (ConfigUtils.LOG.isTraceEnabled()) {
                    iterable = (Iterable<T>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$getInstance$1(org.apache.commons.configuration.Configuration ), ()Ljava/util/Iterator;)((Configuration)environmentConfiguration);
                    size = StreamSupport.stream(iterable.spliterator(), false).count();
                    ConfigUtils.LOG.debug("{} configuration properties found in the common directory for context '{}'.", (Object)size, (Object)context);
                }
            }
            pathProperties = null;
            configResourceName = "/" + context + ".properties";
            configFileAsStream = ConfigUtils.class.getResourceAsStream(configResourceName);
            if (configFileAsStream != null) {
                try {
                    ConfigUtils.LOG.debug("Configuration file for context '{}' found in '{}'. Loading properties from it.", (Object)context, (Object)configResourceName);
                    pathProperties = new PropertiesConfiguration();
                    pathProperties.load((Reader)new InputStreamReader(configFileAsStream));
                    if (!ConfigUtils.LOG.isTraceEnabled()) ** GOTO lbl45
                    iterable = (Iterable<T>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$getInstance$2(org.apache.commons.configuration.Configuration ), ()Ljava/util/Iterator;)((Configuration)environmentConfiguration);
                    size = StreamSupport.stream(iterable.spliterator(), false).count();
                    ConfigUtils.LOG.debug("{} configuration properties found in the path for context '{}'.", (Object)size, (Object)context);
                }
                catch (org.apache.commons.configuration.ConfigurationException ex) {
                    errorMessage = String.format("Exception loading configuration properties for context '%s' from %s: %s", new Object[]{context, configResourceName, ex.getMessage()});
                    ConfigUtils.LOG.error(errorMessage, (Throwable)ex);
                    throw new ConfigurationException(errorMessage);
                }
            } else {
                ConfigUtils.LOG.debug("Configuration file for context '{}' NOT found in '{}'.", (Object)context, (Object)configResourceName);
            }
lbl45:
            // 3 sources

            ConfigUtils.LOG.debug("Looking for any configuration property for context '{}' in the system properties.", (Object)context);
            systemConfiguration = new SystemConfiguration().subset(context);
            if (ConfigUtils.LOG.isTraceEnabled()) {
                iterable = (Iterable<T>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/util/Iterator;, lambda$getInstance$3(org.apache.commons.configuration.Configuration ), ()Ljava/util/Iterator;)((Configuration)systemConfiguration);
                size = StreamSupport.stream(iterable.spliterator(), false).count();
                ConfigUtils.LOG.debug("{} configuration properties found in the system properties for context '{}'.", (Object)size, (Object)context);
            }
            cc = new CompositeConfiguration();
            cc.addConfiguration(systemConfiguration);
            cc.addConfiguration(environmentConfiguration);
            if (commonProperties != null) {
                cc.addConfiguration((Configuration)commonProperties);
            }
            if (pathProperties != null) {
                cc.addConfiguration((Configuration)pathProperties);
            }
            if (ConfigUtils.LOG.isTraceEnabled()) {
                ConfigUtils.LOG.trace("Found Properties:");
                cc.getKeys().forEachRemaining((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getInstance$4(org.apache.commons.configuration.CompositeConfiguration java.lang.String ), (Ljava/lang/String;)V)((CompositeConfiguration)cc));
            }
            conf = new ConfigUtils((Configuration)cc);
            ConfigUtils.INSTANCES.put(context, conf);
        } else {
            ConfigUtils.LOG.debug("Cached Configuration Properties Context {} are being used.", (Object)context);
        }
        return conf;
    }

    public static synchronized void clearConfigUtilsInstancesCache() {
        INSTANCES = new HashMap<String, ConfigUtils>();
        commonDirectory = null;
    }

    private ConfigUtils(Configuration baseConfiguration) {
        this.baseConfiguration = baseConfiguration;
    }

    public Configuration subset(String prefix) {
        return this.baseConfiguration.subset(prefix);
    }

    public boolean isEmpty() {
        return this.baseConfiguration.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.baseConfiguration.containsKey(key);
    }

    public Iterator<String> getKeys(String prefix) {
        return this.baseConfiguration.getKeys(prefix);
    }

    public Iterator<String> getKeys() {
        return this.baseConfiguration.getKeys();
    }

    public boolean getBoolean(String key) {
        return this.baseConfiguration.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.baseConfiguration.getBoolean(key, defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.baseConfiguration.getBoolean(key, defaultValue);
    }

    public byte getByte(String key) {
        return this.baseConfiguration.getByte(key);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.baseConfiguration.getByte(key, defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.baseConfiguration.getByte(key, defaultValue);
    }

    public double getDouble(String key) {
        return this.baseConfiguration.getDouble(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.baseConfiguration.getDouble(key, defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.baseConfiguration.getDouble(key, defaultValue);
    }

    public float getFloat(String key) {
        return this.baseConfiguration.getFloat(key);
    }

    public float getFloat(String key, float defaultValue) {
        return this.baseConfiguration.getFloat(key, defaultValue);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.baseConfiguration.getFloat(key, defaultValue);
    }

    public int getInt(String key) {
        return this.baseConfiguration.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.baseConfiguration.getInt(key, defaultValue);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.baseConfiguration.getInteger(key, defaultValue);
    }

    public long getLong(String key) {
        return this.baseConfiguration.getLong(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.baseConfiguration.getLong(key, defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.baseConfiguration.getLong(key, defaultValue);
    }

    public short getShort(String key) {
        return this.baseConfiguration.getShort(key);
    }

    public short getShort(String key, short defaultValue) {
        return this.baseConfiguration.getShort(key, defaultValue);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.baseConfiguration.getShort(key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.baseConfiguration.getBigDecimal(key);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.baseConfiguration.getBigDecimal(key, defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.baseConfiguration.getBigInteger(key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.baseConfiguration.getBigInteger(key, defaultValue);
    }

    public String getString(String key) {
        return this.baseConfiguration.getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.baseConfiguration.getString(key, defaultValue);
    }

    public String[] getStringArray(String key) {
        return this.baseConfiguration.getStringArray(key);
    }

    public List<Object> getList(String key) {
        return this.baseConfiguration.getList(key);
    }

    public List<Object> getList(String key, List<?> defaultValue) {
        return this.baseConfiguration.getList(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        this.baseConfiguration.setProperty(key, (Object)value);
    }

    private static /* synthetic */ void lambda$getInstance$4(CompositeConfiguration compositeConfiguration, String k) {
        LOG.trace("****** {} -> {}", (Object)k, compositeConfiguration.getProperty(k));
    }

    private static /* synthetic */ Iterator lambda$getInstance$3(Configuration configuration) {
        return configuration.getKeys();
    }

    private static /* synthetic */ Iterator lambda$getInstance$2(Configuration configuration) {
        return configuration.getKeys();
    }

    private static /* synthetic */ Iterator lambda$getInstance$1(Configuration configuration) {
        return configuration.getKeys();
    }

    private static /* synthetic */ Iterator lambda$getInstance$0(Configuration configuration) {
        return configuration.getKeys();
    }
}

