/*
 * Decompiled with CFR 0.152.
 */
package com.cognitivemedicine.config.utils;

import com.cognitivemedicine.config.utils.ConfigurationException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtils.class);
    private static Map<String, ConfigUtils> INSTANCES = Collections.synchronizedMap(new HashMap());
    private final Configuration baseConfiguration;

    public static synchronized ConfigUtils getInstance(String context) {
        LOG.debug("Retrieving configurations for context '{}'.", (Object)context);
        ConfigUtils conf = INSTANCES.get(context);
        if (conf == null) {
            LOG.debug("Configuration for context '{}' is not yet loaded.", (Object)context);
            BaseConfiguration baseConfiguration = new BaseConfiguration();
            String configResourceName = "/" + context + ".properties";
            InputStream configFileAsStream = ConfigUtils.class.getResourceAsStream(configResourceName);
            if (configFileAsStream != null) {
                try {
                    LOG.debug("Configuration file for context '{}' found in '{}'. Loading properties from it.", (Object)context, (Object)configResourceName);
                    PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
                    propertiesConfiguration.load((Reader)new InputStreamReader(configFileAsStream));
                    baseConfiguration.copy((Configuration)propertiesConfiguration);
                }
                catch (org.apache.commons.configuration.ConfigurationException ex) {
                    String errorMessage = String.format("Exception loading configuration properties for context '%s' from %s: %s", context, configResourceName, ex.getMessage());
                    LOG.error(errorMessage, (Throwable)ex);
                    throw new ConfigurationException(errorMessage);
                }
            } else {
                LOG.debug("Configuration file for context '{}' NOT found in '{}'.", (Object)context, (Object)configResourceName);
            }
            LOG.debug("Looking for any configuration property for context '{}' in the environment variables.", (Object)context);
            Configuration environmentConfiguration = new EnvironmentConfiguration().subset(context);
            if (LOG.isTraceEnabled()) {
                Iterable iterable = () -> environmentConfiguration.getKeys();
                long size = StreamSupport.stream(iterable.spliterator(), false).count();
                LOG.debug("{} configuration properties found in the environmental variables for context '{}'.", (Object)size, (Object)context);
            }
            baseConfiguration.copy(environmentConfiguration);
            LOG.debug("Looking for any configuration property for context '{}' in the system properties.", (Object)context);
            Configuration systemConfiguration = new SystemConfiguration().subset(context);
            if (LOG.isTraceEnabled()) {
                Iterable iterable = () -> systemConfiguration.getKeys();
                long size = StreamSupport.stream(iterable.spliterator(), false).count();
                LOG.debug("{} configuration properties found in the system properties for context '{}'.", (Object)size, (Object)context);
            }
            baseConfiguration.copy(systemConfiguration);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found Properties:");
                baseConfiguration.getKeys().forEachRemaining(arg_0 -> ConfigUtils.lambda$getInstance$2((Configuration)baseConfiguration, arg_0));
            }
            conf = new ConfigUtils((Configuration)baseConfiguration);
            INSTANCES.put(context, conf);
        } else {
            LOG.debug("Cached Configuration Properties Context {} are being used.", (Object)context);
        }
        return conf;
    }

    public static synchronized void clearConfigUtilsInstancesCache() {
        INSTANCES = new HashMap<String, ConfigUtils>();
    }

    private ConfigUtils(Configuration baseConfiguration) {
        this.baseConfiguration = baseConfiguration;
    }

    public Configuration subset(String prefix) {
        return this.baseConfiguration.subset(prefix);
    }

    public boolean isEmpty() {
        return this.baseConfiguration.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.baseConfiguration.containsKey(key);
    }

    public Iterator<String> getKeys(String prefix) {
        return this.baseConfiguration.getKeys(prefix);
    }

    public Iterator<String> getKeys() {
        return this.baseConfiguration.getKeys();
    }

    public boolean getBoolean(String key) {
        return this.baseConfiguration.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.baseConfiguration.getBoolean(key, defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.baseConfiguration.getBoolean(key, defaultValue);
    }

    public byte getByte(String key) {
        return this.baseConfiguration.getByte(key);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.baseConfiguration.getByte(key, defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.baseConfiguration.getByte(key, defaultValue);
    }

    public double getDouble(String key) {
        return this.baseConfiguration.getDouble(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.baseConfiguration.getDouble(key, defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.baseConfiguration.getDouble(key, defaultValue);
    }

    public float getFloat(String key) {
        return this.baseConfiguration.getFloat(key);
    }

    public float getFloat(String key, float defaultValue) {
        return this.baseConfiguration.getFloat(key, defaultValue);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.baseConfiguration.getFloat(key, defaultValue);
    }

    public int getInt(String key) {
        return this.baseConfiguration.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.baseConfiguration.getInt(key, defaultValue);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.baseConfiguration.getInteger(key, defaultValue);
    }

    public long getLong(String key) {
        return this.baseConfiguration.getLong(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.baseConfiguration.getLong(key, defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.baseConfiguration.getLong(key, defaultValue);
    }

    public short getShort(String key) {
        return this.baseConfiguration.getShort(key);
    }

    public short getShort(String key, short defaultValue) {
        return this.baseConfiguration.getShort(key, defaultValue);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.baseConfiguration.getShort(key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.baseConfiguration.getBigDecimal(key);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.baseConfiguration.getBigDecimal(key, defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.baseConfiguration.getBigInteger(key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.baseConfiguration.getBigInteger(key, defaultValue);
    }

    public String getString(String key) {
        return this.baseConfiguration.getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.baseConfiguration.getString(key, defaultValue);
    }

    public String[] getStringArray(String key) {
        return this.baseConfiguration.getStringArray(key);
    }

    public List<Object> getList(String key) {
        return this.baseConfiguration.getList(key);
    }

    public List<Object> getList(String key, List<?> defaultValue) {
        return this.baseConfiguration.getList(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        this.baseConfiguration.setProperty(key, (Object)value);
    }

    private static /* synthetic */ void lambda$getInstance$2(Configuration configuration, String k) {
        LOG.trace("****** {} -> {}", (Object)k, configuration.getProperty(k));
    }
}

