/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.cartridges.calc;

import jakarta.annotation.PostConstruct;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Producer;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.api.resource.visitor.VisitAfterIf;
import org.smooks.api.resource.visitor.VisitBeforeIf;
import org.smooks.api.resource.visitor.dom.DOMVisitAfter;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.cartridges.calc.CountDirection;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@VisitBeforeIf(condition="!executeAfter")
@VisitAfterIf(condition="executeAfter")
public class Counter
implements BeforeVisitor,
AfterVisitor,
DOMVisitBefore,
DOMVisitAfter,
Producer {
    public static final Long DEFAULT_START_INDEX = 0L;
    public static final int DEFAULT_AMOUNT = 1;
    @Inject
    @Named(value="beanId")
    private String beanIdName;
    @Inject
    private Optional<Long> start;
    @Inject
    private Optional<Integer> amount;
    @Inject
    private Optional<ExpressionEvaluator> amountExpression;
    @Inject
    private Optional<ExpressionEvaluator> startExpression;
    @Inject
    private Optional<ExpressionEvaluator> resetCondition;
    @Inject
    private CountDirection direction = CountDirection.INCREMENT;
    @Inject
    private Boolean executeAfter = false;
    private BeanId beanId;
    @Inject
    private ApplicationContext appContext;

    @PostConstruct
    public void initialize() {
        this.beanId = this.appContext.getBeanIdStore().register(this.beanIdName);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.count(executionContext, (Fragment<?>)new NodeFragment((Node)element));
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.count(executionContext, (Fragment<?>)new NodeFragment((Node)element));
    }

    public void count(ExecutionContext executionContext, Fragment<?> source) {
        BeanContext beanContext = executionContext.getBeanContext();
        Long value = (Long)beanContext.getBean(this.beanId);
        if (value == null || this.resetCondition.isPresent() && this.resetCondition.get().eval((Object)beanContext.getBeanMap())) {
            value = this.getStart(beanContext);
        } else {
            int amount = this.getAmount(beanContext);
            value = this.direction == CountDirection.INCREMENT ? Long.valueOf(value + (long)amount) : Long.valueOf(value - (long)amount);
        }
        beanContext.addBean(this.beanId, (Object)value, source);
    }

    private Long getStart(BeanContext beanContext) {
        if (!this.start.isPresent() && !this.startExpression.isPresent()) {
            return DEFAULT_START_INDEX;
        }
        if (this.start.isPresent()) {
            return this.start.get();
        }
        Object result = this.startExpression.get().getValue((Object)beanContext.getBeanMap());
        if (!(result instanceof Long) && !(result instanceof Integer)) {
            throw new SmooksException("The start expression must result in a Integer or a Long");
        }
        return new Long(result.toString());
    }

    public Boolean getExecuteAfter() {
        return this.executeAfter;
    }

    private int getAmount(BeanContext beanContext) {
        if (!this.amount.isPresent() && !this.amountExpression.isPresent()) {
            return 1;
        }
        if (this.amount.isPresent()) {
            return this.amount.get();
        }
        Object result = this.amountExpression.get().getValue((Object)beanContext.getBeanMap());
        if (!(result instanceof Integer)) {
            throw new SmooksException("The amount expression must result in a Integer");
        }
        return (Integer)result;
    }

    public Set<? extends Object> getProducts() {
        return Stream.of(this.beanIdName).collect(Collectors.toSet());
    }
}

