/*
 * Decompiled with CFR 0.152.
 */
package org.smerty.jham;

import org.smerty.jham.Angle;
import org.smerty.jham.Latitude;
import org.smerty.jham.Longitude;

public class Location {
    private static final double AVG_EARTH_RADIUS_KM = 6371.009;
    private static final double AVG_EARTH_RADIUS_SM = 3958.761;
    private static final double AVG_EARTH_RADIUS_NM = 3440.069;
    private Latitude latitude;
    private Longitude longitude;

    public Location() {
        this.latitude = new Latitude();
        this.longitude = new Longitude();
    }

    public Location(Latitude latitudeIn, Longitude longitudeIn) {
        this.latitude = latitudeIn;
        this.longitude = longitudeIn;
    }

    public Location(double latitudeIn, double longitudeIn) {
        this.latitude = Latitude.fromDegrees(latitudeIn);
        this.longitude = Longitude.fromDegrees(longitudeIn);
    }

    public Location(String maidenhead) {
        this.latitude = Location.extractLat(maidenhead);
        this.longitude = Location.extractLon(maidenhead);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            return ((Location)obj).hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + this.latitude.hashCode();
        hash = hash * 31 + this.longitude.hashCode();
        return hash;
    }

    public String toMaidenhead() {
        return Location.toMaidenhead(this.latitude.toDegrees(), this.longitude.toDegrees());
    }

    public static String toMaidenhead(double latitudeIn, double longitudeIn) {
        double longitude = longitudeIn + 180.0;
        char lonFirst = (char)(65.0 + (longitude /= 2.0) / 10.0);
        char lonSecond = (char)(48.0 + longitude % 10.0);
        char lonThird = (char)(65.0 + longitude % 1.0 * 24.0);
        double latitude = latitudeIn + 90.0;
        char latFirst = (char)(65.0 + latitude / 10.0);
        char latSecond = (char)(48.0 + latitude % 10.0);
        char latThird = (char)(65.0 + latitude % 1.0 * 24.0);
        StringBuilder sb = new StringBuilder();
        sb.append(lonFirst);
        sb.append(latFirst);
        sb.append(lonSecond);
        sb.append(latSecond);
        sb.append(("" + lonThird).toLowerCase());
        sb.append(("" + latThird).toLowerCase());
        return sb.toString();
    }

    public static Latitude extractLat(String maidenheadIn) {
        String maidenhead = maidenheadIn.toUpperCase();
        double latitude = (double)(-90 + 10 * (maidenhead.charAt(1) - 65) + (maidenhead.charAt(3) - 48)) + 0.041666666666666664 * (double)(maidenhead.charAt(5) - 65) + 0.020833333333333332;
        return Latitude.fromDegrees(latitude);
    }

    public static Longitude extractLon(String maidenheadIn) {
        String maidenhead = maidenheadIn.toUpperCase();
        double longitude = (double)(-180 + 20 * (maidenhead.charAt(0) - 65) + 2 * (maidenhead.charAt(2) - 48)) + 0.08333333333333333 * (double)(maidenhead.charAt(4) - 65) + 0.041666666666666664;
        return Longitude.fromDegrees(longitude);
    }

    public Latitude getLatitude() {
        return this.latitude;
    }

    public Longitude getLongitude() {
        return this.longitude;
    }

    public void setLatitude(Latitude latitudeIn) {
        this.latitude = latitudeIn;
    }

    public void setLongitude(Longitude longitudeIn) {
        this.longitude = longitudeIn;
    }

    public double getDistanceMi(Location loc2) {
        return Location.getDistanceMi(this, loc2);
    }

    public double getDistanceKm(Location loc2) {
        return Location.getDistanceKm(this, loc2);
    }

    public double getDistanceNm(Location loc2) {
        return Location.getDistanceNm(this, loc2);
    }

    public static double getDistanceMi(Location loc1, Location loc2) {
        return Location.getDistance(loc1, loc2, 3958.761);
    }

    private static double getDistanceKm(Location loc1, Location loc2) {
        return Location.getDistance(loc1, loc2, 6371.009);
    }

    private static double getDistanceNm(Location loc1, Location loc2) {
        return Location.getDistance(loc1, loc2, 3440.069);
    }

    private static double getDistance(Location loc1, Location loc2, double radius) {
        if (loc1.equals(loc2)) {
            return 0.0;
        }
        return Math.acos(Math.sin(loc1.getLatitude().getRadians()) * Math.sin(loc2.getLatitude().getRadians()) + Math.cos(loc1.getLatitude().getRadians()) * Math.cos(loc2.getLatitude().getRadians()) * Math.cos(loc2.getLongitude().getRadians() - loc1.getLongitude().getRadians())) * radius;
    }

    public double getBearing(Location loc2) {
        return Location.getBearing(this, loc2);
    }

    public static double getBearing(Location loc1, Location loc2) {
        if (loc1.equals(loc2)) {
            return Double.NaN;
        }
        double dLon = loc2.getLongitude().getRadians() - loc1.getLongitude().getRadians();
        double y = Math.sin(dLon) * Math.cos(loc2.getLatitude().getRadians());
        double x = Math.cos(loc1.getLatitude().getRadians()) * Math.sin(loc2.getLatitude().getRadians()) - Math.sin(loc1.getLatitude().getRadians()) * Math.cos(loc2.getLatitude().getRadians()) * Math.cos(dLon);
        return (Angle.radiansToDegrees(Math.atan2(y, x)) + 360.0) % 360.0;
    }
}

