/*
 * Decompiled with CFR 0.152.
 */
package org.smerty.jham;

import java.math.BigDecimal;
import java.math.MathContext;

public class Angle {
    private static final BigDecimal BIG_PI = new BigDecimal(Math.PI);
    protected BigDecimal radians;

    public Angle() {
    }

    public Angle(double radiansIn) {
        this.radians = new BigDecimal(radiansIn);
    }

    public int hashCode() {
        int prime = 7;
        if (this.radians == null) {
            return 7;
        }
        return 7 + this.radians.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Angle)) {
            return false;
        }
        return ((Angle)obj).hashCode() == this.hashCode();
    }

    public static Angle fromDegrees(double degrees) {
        Angle angle = new Angle();
        angle.radians = Angle.degreesToRadians(new BigDecimal(degrees), MathContext.DECIMAL128);
        return angle;
    }

    public void setRadians(double radiansIn) {
        this.radians = new BigDecimal(radiansIn);
    }

    public double getRadians() {
        return this.radians.doubleValue();
    }

    public double toDegrees() {
        return Angle.radiansToDegrees(this.radians, MathContext.DECIMAL128).doubleValue();
    }

    public static double radiansToDegrees(double radians) {
        return Angle.radiansToDegrees(new BigDecimal(radians), MathContext.DECIMAL128).doubleValue();
    }

    public static double degreesToRadians(double degrees) {
        return Angle.degreesToRadians(new BigDecimal(degrees), MathContext.DECIMAL128).doubleValue();
    }

    protected static BigDecimal radiansToDegrees(BigDecimal radians, MathContext mc) {
        return radians.multiply(new BigDecimal(180)).divide(BIG_PI, mc);
    }

    protected static BigDecimal degreesToRadians(BigDecimal degrees, MathContext mc) {
        return degrees.divide(new BigDecimal(180), mc).multiply(BIG_PI);
    }
}

