/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.layers;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.controller.JsfBaseDetailControllerFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.controller.JsfBaseListControllerFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.controller.JsfCommonControllerFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.controller.JsfDetailControllerFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.controller.JsfListControllerFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.controller.configuration.WebappLogbackFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.controller.configuration.WebappProjectLocalPropertiesFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.controller.configuration.WebappProjectPropertiesFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.controller.resources.JsfBaseControllerFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.model.JsfCommonViewFileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class JsfControllerLayer
extends AbstractLayer {
    public JsfControllerLayer() {
        super("MVC Controller");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        FileWriteCommandTreeNode resourcesTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode baseControllerTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new JsfBaseControllerFileWriteCommand(project));
        resourcesTreeNode.add((MutableTreeNode)baseControllerTreeNode);
        return resourcesTreeNode;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode propertiesTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new WebappProjectPropertiesFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)propertiesTreeNode);
        FileWriteCommandTreeNode localPropertiesTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new WebappProjectLocalPropertiesFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)localPropertiesTreeNode);
        FileWriteCommandTreeNode logbackTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new WebappLogbackFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)logbackTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode mvcLayerTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode commonControllerTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new JsfCommonControllerFileWriteCommand(project));
        mvcLayerTreeNode.add((MutableTreeNode)commonControllerTreeNode);
        FileWriteCommandTreeNode commonViewTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new JsfCommonViewFileWriteCommand(project));
        mvcLayerTreeNode.add((MutableTreeNode)commonViewTreeNode);
        FileWriteCommandTreeNode baseControllerTreeNode = new FileWriteCommandTreeNode("Base Controllers");
        mvcLayerTreeNode.add((MutableTreeNode)baseControllerTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            baseControllerTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode listBeanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new JsfBaseListControllerFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)listBeanTreeNode);
                FileWriteCommandTreeNode detailBeanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new JsfBaseDetailControllerFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)detailBeanTreeNode);
            }
        }
        FileWriteCommandTreeNode controllerTreeNode = new FileWriteCommandTreeNode("Controllers");
        mvcLayerTreeNode.add((MutableTreeNode)controllerTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            controllerTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode listBeanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new JsfListControllerFileWriteCommand(bean));
                controllerTreeNode.add((MutableTreeNode)listBeanTreeNode);
                FileWriteCommandTreeNode detailBeanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new JsfDetailControllerFileWriteCommand(bean));
                controllerTreeNode.add((MutableTreeNode)detailBeanTreeNode);
            }
        }
        return mvcLayerTreeNode;
    }
}

