/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.commands.presentation;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.skeletons.commands.impl.typed.PropertiesFileWriteCommand;

public class I18nFileWriteCommand
extends PropertiesFileWriteCommand {
    private Project project;

    public I18nFileWriteCommand(Project project) {
        super(project.workspaceFolder + File.separator + project.model.webappArtefactName + File.separator + project.model.resourcesFolder, "i18n");
        this.project = project;
    }

    protected void writeContent() throws IOException {
        this.writeLine("#");
        this.writeLine("# auto generated i18n file");
        this.writeLine("# write modifications between specific code marks");
        this.writeLine("# processed by skeleton-generator");
        this.writeLine("#");
        this.skipLine();
        for (Package myPackage : this.project.model.packages) {
            for (Bean bean : myPackage.beans) {
                this.writeLine("#" + bean.className);
                this.writeLine(bean.objectName + "List=" + bean.listRendering);
                this.writeLine(bean.objectName + "Details=" + bean.detailRendering);
                for (ViewProperty property : bean.formBean.properties) {
                    this.writeLine(bean.objectName + property.capName + "=" + property.rendering);
                }
                this.skipLine();
            }
        }
        this.writeNotOverridableContent();
    }
}

