/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.commands.controller;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToMany;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.model.metadata.DetailMode;
import org.sklsft.generator.model.metadata.Visibility;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class JsfBaseDetailControllerFileWriteCommand
extends JavaFileWriteCommand {
    protected Bean bean;

    public JsfBaseDetailControllerFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.webappArtefactName + File.separator + bean.myPackage.model.javaSourcesFolder + File.separator + bean.myPackage.baseDetailControllerPackageName.replace(".", File.separator), bean.baseDetailControllerClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.ArrayList;");
        this.javaImports.add("import javax.annotation.PostConstruct;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import org.sklsft.commons.mvc.ajax.AjaxMethodTemplate;");
        this.javaImports.add("import org.sklsft.commons.mvc.annotations.AjaxMethod;");
        this.javaImports.add("import org.sklsft.commons.api.exception.rights.AccessDeniedException;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollForm;");
        this.javaImports.add("import org.sklsft.commons.mvc.annotations.PageLoad;");
        this.javaImports.add("import " + this.bean.myPackage.model.controllerPackageName + ".CommonController;");
        this.javaImports.add("import " + this.bean.myPackage.model.controllerPackageName + ".BaseController;");
        this.javaImports.add("import " + this.bean.myPackage.serviceInterfacePackageName + "." + this.bean.serviceInterfaceName + ";");
        this.javaImports.add("import " + this.bean.myPackage.detailViewPackageName + "." + this.bean.detailViewClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.formsPackageName + "." + this.bean.formBean.className + ";");
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.filtersPackageName + "." + currentBean.basicViewBean.filter.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.sortingsPackageName + "." + currentBean.basicViewBean.sortingClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.basicViewsPackageName + "." + currentBean.basicViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
        }
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            currentBean = oneToMany.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.filtersPackageName + "." + currentBean.basicViewBean.filter.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.sortingsPackageName + "." + currentBean.basicViewBean.sortingClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.basicViewsPackageName + "." + currentBean.basicViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.formsPackageName + "." + currentBean.formBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.serviceInterfacePackageName + "." + currentBean.serviceInterfaceName + ";");
        }
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseDetailControllerPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base detail controller class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.baseDetailControllerClassName + " extends BaseController {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * services injected by spring");
        this.writeLine(" */");
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.serviceInterfaceName + " " + this.bean.serviceObjectName + ";");
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            Bean currentBean = oneToMany.referenceBean;
            this.writeLine("@Inject");
            this.writeLine("protected " + currentBean.serviceInterfaceName + " " + currentBean.serviceObjectName + ";");
        }
        this.writeLine("@Inject");
        this.writeLine("protected CommonController commonController;");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * view");
        this.writeLine(" */");
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.detailViewClassName + " " + this.bean.detailViewObjectName + ";");
        this.skipLine();
        this.createLoadObject();
        this.createLoadOneToOneComponent();
        this.createLoadOneToManyComponent();
        this.createLoadOneToMany();
        this.createSaveOneToOneComponent();
        this.createCreateOneToManyComponent();
        this.createCreateOneToMany();
        this.createSaveOneToManyComponent();
        this.createSaveOneToMany();
        this.createUpdateObject();
        this.createEditOneToMany();
        this.createUpdateOneToMany();
        this.createEditOneToManyComponent();
        this.createUpdateOneToOneComponent();
        this.createUpdateOneToManyComponent();
        this.createDeleteOneToOneComponent();
        this.createDeleteOneToManyComponent();
        this.createDeleteOneToMany();
        this.createDeleteOneToManyComponentList();
        this.createDeleteOneToManyList();
        this.createResetFlters();
        this.writeLine("}");
    }

    private void createLoadObject() {
        this.writeLine("/**");
        this.writeLine(" * load object");
        this.writeLine(" */");
        this.writeLine("@PageLoad");
        this.writeLine("public void load() {");
        for (ViewProperty property : this.bean.formBean.properties) {
            if (!property.isComboboxable() || !property.visibility.isDetailVisible()) continue;
            this.writeLine("this.commonController.load" + property.selectableBean.className + "Options();");
        }
        this.writeLine(this.bean.detailViewObjectName + ".setSelected" + this.bean.className + "(this." + this.bean.serviceObjectName + ".load(this." + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getId()));");
        this.writeLine("}");
        this.skipLine();
        this.skipLine();
    }

    private void createLoadOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@PageLoad");
            this.writeLine("public void load" + currentBean.className + "() {");
            for (ViewProperty property : currentBean.formBean.properties) {
                if (!property.isComboboxable() || !property.editable) continue;
                this.writeLine("this.commonController.load" + property.selectableBean.className + "Options();");
            }
            this.writeLine(this.bean.detailViewObjectName + ".setSelected" + currentBean.className + "(this." + this.bean.serviceObjectName + ".load" + currentBean.className + "(this." + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getId()));");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("@PageLoad");
            this.writeLine("public void load" + currentBean.className + "List() {");
            this.writeLine("this.reset" + currentBean.basicViewBean.filter.className + "();");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * refresh one to many " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("public void refresh" + currentBean.className + "List() {");
            this.writeLine(this.bean.detailViewObjectName + ".set" + currentBean.className + "ScrollView(" + this.bean.serviceObjectName + ".scroll" + currentBean.className + "(" + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getId(), " + this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollForm()));");
            this.writeLine(this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollForm().setPage(" + this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollView().getCurrentPage());");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadOneToMany() {
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            Bean currentBean = oneToMany.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("@PageLoad");
            this.writeLine("public void load" + currentBean.className + "List() {");
            this.writeLine("this.reset" + currentBean.basicViewBean.filter.className + "();");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * refresh one to many " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("public void refresh" + currentBean.className + "List() {");
            this.writeLine(this.bean.detailViewObjectName + ".set" + currentBean.className + "ScrollView(" + currentBean.serviceObjectName + ".scrollFrom" + oneToMany.referenceProperty.capName + "(" + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getId(), " + this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollForm()));");
            this.writeLine(this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollForm().setPage(" + this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollView().getCurrentPage());");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createUpdateObject() {
        this.writeLine("/**");
        this.writeLine(" * update object");
        this.writeLine(" */");
        this.writeLine("@AjaxMethod(\"" + this.bean.className + ".update" + '\"' + ")");
        this.writeLine("public void update() {");
        this.writeLine(this.bean.serviceObjectName + ".update(" + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getId(), " + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getForm());");
        this.writeLine("load();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createUpdateOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@AjaxMethod(\"" + currentBean.className + ".update" + '\"' + ")");
            this.writeLine("public void update" + currentBean.className + "() {");
            this.writeLine(this.bean.serviceObjectName + ".update" + currentBean.className + "(this." + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getId(), " + this.bean.detailViewObjectName + ".getSelected" + currentBean.className + "().getForm());");
            this.writeLine("load" + currentBean.className + "();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@AjaxMethod(\"" + currentBean.className + ".save" + '\"' + ")");
            this.writeLine("public void save" + currentBean.className + "() {");
            this.writeLine(this.bean.serviceObjectName + ".save" + currentBean.className + "(this." + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getId(), " + this.bean.detailViewObjectName + ".getSelected" + currentBean.className + "().getForm());");
            this.writeLine("load" + currentBean.className + "();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createCreateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * create one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("public void create" + currentBean.className + "() {");
            for (ViewProperty property : currentBean.formBean.properties) {
                if (!property.isComboboxable() || !property.visibility.isDetailVisible()) continue;
                this.writeLine("this.commonController.load" + property.selectableBean.className + "Options();");
            }
            this.writeLine("try {");
            this.writeLine(this.bean.detailViewObjectName + ".setSelected" + currentBean.className + "(this." + this.bean.serviceObjectName + ".create" + currentBean.className + "(this." + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getId()));");
            this.writeLine("} catch (AccessDeniedException e) {");
            this.writeLine("displayError(e.getMessage());");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createCreateOneToMany() {
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            Bean currentBean = oneToMany.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * create one to many " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("public void create" + currentBean.className + "() {");
            for (ViewProperty property : oneToMany.formBean.properties) {
                if (!property.isComboboxable() || !property.visibility.isDetailVisible()) continue;
                this.writeLine("this.commonController.load" + property.selectableBean.className + "Options();");
            }
            this.writeLine("try {");
            this.writeLine(this.bean.detailViewObjectName + ".setSelected" + currentBean.className + "(this." + currentBean.serviceObjectName + ".create());");
            this.writeLine("} catch (AccessDeniedException e) {");
            this.writeLine("displayError(e.getMessage());");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@AjaxMethod(\"" + currentBean.className + ".save" + '\"' + ")");
            this.writeLine("public void save" + currentBean.className + "() {");
            this.writeLine(this.bean.serviceObjectName + ".save" + currentBean.className + "(this." + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getId(), " + this.bean.detailViewObjectName + ".getSelected" + currentBean.className + "().getForm());");
            this.writeLine("load" + currentBean.className + "List();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveOneToMany() {
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            Bean currentBean = oneToMany.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many " + currentBean.objectName);
            this.writeLine(" */");
            if (currentBean.detailMode.equals((Object)DetailMode.MODAL)) {
                this.writeLine("@AjaxMethod(\"" + currentBean.className + ".save" + '\"' + ")");
                this.writeLine("public void save" + currentBean.className + "() {");
                this.writeLine("load();");
                this.writeLine(currentBean.formBean.className + " form = " + this.bean.detailViewObjectName + ".getSelected" + currentBean.className + "().getForm();");
                this.writeLine(this.bean.formBean.className + " " + this.bean.formBean.objectName + " = " + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getForm();");
                for (ViewProperty property : this.bean.referenceViewProperties) {
                    this.writeLine("form.set" + oneToMany.referenceProperty.capName + property.capName + "(" + this.bean.formBean.objectName + ".get" + property.capName + "());");
                }
                this.writeLine(currentBean.serviceObjectName + ".save(form);");
                this.writeLine("refresh" + currentBean.className + "List();");
                this.writeLine("}");
                this.skipLine();
                continue;
            }
            this.writeLine("public void save" + currentBean.className + "() {");
            this.writeLine("executeAjaxMethod(\"" + currentBean.className + ".save" + '\"' + ", new AjaxMethodTemplate() {");
            this.writeLine("@Override");
            this.writeLine("public Object execute() {");
            this.writeLine("load();");
            this.writeLine(currentBean.formBean.className + " form = " + this.bean.detailViewObjectName + ".getSelected" + currentBean.className + "().getForm();");
            this.writeLine(this.bean.formBean.className + " " + this.bean.formBean.objectName + " = " + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getForm();");
            for (ViewProperty property : this.bean.referenceViewProperties) {
                this.writeLine("form.set" + oneToMany.referenceProperty.capName + property.capName + "(" + this.bean.formBean.objectName + ".get" + property.capName + "());");
            }
            this.writeLine("return " + currentBean.serviceObjectName + ".save(form);");
            this.writeLine("}");
            this.writeLine("@Override");
            this.writeLine("public void redirectOnComplete(Object result) {");
            this.writeLine("redirect(\"/sections/" + currentBean.myPackage.urlPiece + "/" + currentBean.urlPiece + "/details.jsf?id=" + '\"' + " + result);");
            this.writeLine("}");
            this.writeLine("});");
            this.writeLine("}");
        }
    }

    private void createEditOneToMany() {
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            Bean currentBean = oneToMany.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * edit one to many " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("public void edit" + currentBean.className + "(" + currentBean.idType + " id) {");
            for (ViewProperty property : oneToMany.formBean.properties) {
                if (!property.isComboboxable() || property.visibility.equals((Object)Visibility.NOT_VISIBLE) || !property.editable) continue;
                this.writeLine("this.commonController.load" + property.selectableBean.className + "Options();");
            }
            this.writeLine(this.bean.detailViewObjectName + ".setSelected" + currentBean.className + "(" + currentBean.serviceObjectName + ".load(id));");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createUpdateOneToMany() {
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            Bean currentBean = oneToMany.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to many " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@AjaxMethod(\"" + currentBean.className + ".update" + '\"' + ")");
            this.writeLine("public void update" + currentBean.className + "() {");
            this.writeLine(currentBean.serviceObjectName + ".update(" + this.bean.detailViewObjectName + ".getSelected" + currentBean.className + "().getId(), " + this.bean.detailViewObjectName + ".getSelected" + currentBean.className + "().getForm());");
            this.writeLine("refresh" + currentBean.className + "List();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createEditOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * edit one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("public void edit" + currentBean.className + "(" + currentBean.idType + " id) {");
            for (ViewProperty property : currentBean.formBean.properties) {
                if (!property.isComboboxable() || property.visibility.equals((Object)Visibility.NOT_VISIBLE) || !property.editable) continue;
                this.writeLine("this.commonController.load" + property.selectableBean.className + "Options();");
            }
            this.writeLine(this.bean.detailViewObjectName + ".setSelected" + currentBean.className + "(" + this.bean.serviceObjectName + ".load" + currentBean.className + "(id));");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createUpdateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@AjaxMethod(\"" + currentBean.className + ".update" + '\"' + ")");
            this.writeLine("public void update" + currentBean.className + "() {");
            this.writeLine(this.bean.serviceObjectName + ".update" + currentBean.className + "(" + this.bean.detailViewObjectName + ".getSelected" + currentBean.className + "().getId(), " + this.bean.detailViewObjectName + ".getSelected" + currentBean.className + "().getForm());");
            this.writeLine("load" + currentBean.className + "List();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@AjaxMethod(\"" + currentBean.className + ".delete" + '\"' + ")");
            this.writeLine("public void delete" + currentBean.className + "() {");
            this.writeLine(this.bean.serviceObjectName + ".delete" + currentBean.className + "(this." + this.bean.detailViewObjectName + ".getSelected" + this.bean.className + "().getId());");
            this.writeLine("load" + currentBean.className + "();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@AjaxMethod(\"" + currentBean.className + ".delete" + '\"' + ")");
            this.writeLine("public void delete" + currentBean.className + "(" + currentBean.idType + " id) {");
            this.writeLine(this.bean.serviceObjectName + ".delete" + currentBean.className + "(id);");
            this.writeLine("load" + currentBean.className + "List();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteOneToMany() {
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            Bean currentBean = oneToMany.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@AjaxMethod(\"" + currentBean.className + ".delete" + '\"' + ")");
            this.writeLine("public void delete" + currentBean.className + "(" + currentBean.idType + " id) {");
            this.writeLine(currentBean.serviceObjectName + ".delete(id);");
            this.writeLine("refresh" + currentBean.className + "List();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("@AjaxMethod(\"" + currentBean.className + ".deleteList" + '\"' + ")");
            this.writeLine("public void delete" + currentBean.className + "List() {");
            this.writeLine("List<" + currentBean.idType + "> ids = new ArrayList<>();");
            this.writeLine("for (" + currentBean.basicViewBean.className + " " + currentBean.objectName + ":" + this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollView().getElements()) {");
            this.writeLine("if (" + currentBean.objectName + ".getSelected()) {");
            this.writeLine("ids.add(" + currentBean.objectName + ".getId());");
            this.writeLine("}");
            this.writeLine("}");
            this.writeLine(this.bean.serviceObjectName + ".delete" + currentBean.className + "List(ids);");
            this.writeLine("load" + currentBean.className + "List();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteOneToManyList() {
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            Bean currentBean = oneToMany.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("@AjaxMethod(\"" + currentBean.className + ".deleteList" + '\"' + ")");
            this.writeLine("public void delete" + currentBean.className + "List() {");
            this.writeLine("List<" + currentBean.idType + "> ids = new ArrayList<>();");
            this.writeLine("for (" + currentBean.basicViewBean.className + " " + currentBean.objectName + ":" + this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollView().getElements()) {");
            this.writeLine("if (" + currentBean.objectName + ".getSelected()) {");
            this.writeLine("ids.add(" + currentBean.objectName + ".getId());");
            this.writeLine("}");
            this.writeLine("}");
            this.writeLine(currentBean.serviceObjectName + ".deleteList(ids);");
            this.writeLine("refresh" + currentBean.className + "List();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createResetFlters() {
        Bean currentBean;
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * reset one to many component " + currentBean.basicViewBean.filter.className + " datatable filter");
            this.writeLine(" */");
            this.writeLine("public void reset" + currentBean.basicViewBean.filter.className + "() {");
            this.writeLine("this." + this.bean.detailViewObjectName + ".set" + currentBean.className + "ScrollForm(new ScrollForm<>());");
            this.writeLine("this." + this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollForm().setFilter(new " + currentBean.basicViewBean.filter.className + "());");
            this.writeLine("this." + this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollForm().setSorting(new " + currentBean.basicViewBean.sortingClassName + "());");
            this.writeLine("refresh" + currentBean.className + "List();");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            currentBean = oneToMany.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * reset one to many " + currentBean.basicViewBean.filter.className + " datatable filter and sorting");
            this.writeLine(" */");
            this.writeLine("public void reset" + currentBean.basicViewBean.filter.className + "() {");
            this.writeLine("this." + this.bean.detailViewObjectName + ".set" + currentBean.className + "ScrollForm(new ScrollForm<>());");
            this.writeLine("this." + this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollForm().setFilter(new " + currentBean.basicViewBean.filter.className + "());");
            this.writeLine("this." + this.bean.detailViewObjectName + ".get" + currentBean.className + "ScrollForm().setSorting(new " + currentBean.basicViewBean.sortingClassName + "());");
            this.writeLine("refresh" + currentBean.className + "List();");
            this.writeLine("}");
            this.skipLine();
        }
    }
}

