/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.commands.model;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToMany;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class MvcDetailViewFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public MvcDetailViewFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.webappArtefactName + File.separator + bean.myPackage.model.javaSourcesFolder + File.separator + bean.myPackage.detailViewPackageName.replace(".", File.separator), bean.detailViewClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import java.io.Serializable;");
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import org.springframework.stereotype.Component;");
        this.javaImports.add("import org.springframework.context.annotation.Scope;");
        this.javaImports.add("import org.springframework.web.context.WebApplicationContext;");
        this.javaImports.add("import org.sklsft.commons.mvc.scopes.ViewScope;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollForm;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollView;");
        this.javaImports.add("import " + this.bean.myPackage.fullViewsPackageName + "." + this.bean.fullViewBean.className + ";");
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.basicViewsPackageName + "." + currentBean.basicViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.filtersPackageName + "." + currentBean.basicViewBean.filterClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.sortingsPackageName + "." + currentBean.basicViewBean.sortingClassName + ";");
        }
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            currentBean = oneToMany.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.basicViewsPackageName + "." + currentBean.basicViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.fullViewsPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.filtersPackageName + "." + currentBean.basicViewBean.filterClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.sortingsPackageName + "." + currentBean.basicViewBean.sortingClassName + ";");
        }
    }

    protected void writeContent() throws IOException {
        Bean currentBean;
        this.writeLine("package " + this.bean.myPackage.detailViewPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated detail view class file");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("@Component");
        this.writeLine("@Scope(ViewScope.NAME)");
        this.writeLine("public class " + this.bean.detailViewClassName + " implements Serializable {");
        this.skipLine();
        this.writeLine("private static final long serialVersionUID = 1L;");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        this.writeLine("private " + this.bean.fullViewBean.className + " selected" + this.bean.className + " = new " + this.bean.fullViewBean.className + "();");
        this.skipLine();
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("private " + currentBean.fullViewBean.className + " selected" + oneToOneComponent.referenceBean.className + ";");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("protected ScrollForm<" + currentBean.basicViewBean.filterClassName + ", " + currentBean.basicViewBean.sortingClassName + "> " + currentBean.objectName + "ScrollForm = new ScrollForm<>();");
            this.writeLine("protected ScrollView<" + currentBean.basicViewBean.className + "> " + currentBean.objectName + "ScrollView = new ScrollView<>();");
            this.writeLine("private " + currentBean.fullViewBean.className + " selected" + currentBean.className + " = new " + currentBean.fullViewBean.className + "();");
            this.skipLine();
        }
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            currentBean = oneToMany.referenceBean;
            this.writeLine("protected ScrollForm<" + currentBean.basicViewBean.filterClassName + ", " + currentBean.basicViewBean.sortingClassName + "> " + currentBean.objectName + "ScrollForm = new ScrollForm<>();");
            this.writeLine("protected ScrollView<" + currentBean.basicViewBean.className + "> " + currentBean.objectName + "ScrollView = new ScrollView<>();");
            this.writeLine("private " + currentBean.fullViewBean.className + " selected" + currentBean.className + " = new " + currentBean.fullViewBean.className + "();");
            this.skipLine();
        }
        this.writeLine("/*");
        this.writeLine(" * getters and setters");
        this.writeLine(" */");
        this.writeLine("public " + this.bean.fullViewBean.className + " getSelected" + this.bean.className + "() {");
        this.writeLine("return selected" + this.bean.className + ";");
        this.writeLine("}");
        this.writeLine("public void setSelected" + this.bean.className + "(" + this.bean.fullViewBean.className + " selected" + this.bean.className + ") {");
        this.writeLine("this.selected" + this.bean.className + " = selected" + this.bean.className + ";");
        this.writeLine("}");
        this.skipLine();
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("public " + currentBean.fullViewBean.className + " getSelected" + currentBean.className + "() {");
            this.writeLine("return selected" + currentBean.className + ";");
            this.writeLine("}");
            this.writeLine("public void setSelected" + currentBean.className + "(" + currentBean.fullViewBean.className + " selected" + currentBean.className + ") {");
            this.writeLine("this.selected" + currentBean.className + " = selected" + currentBean.className + ";");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("public ScrollView<" + currentBean.basicViewBean.className + "> get" + currentBean.className + "ScrollView() {");
            this.writeLine("return " + currentBean.objectName + "ScrollView;");
            this.writeLine("}");
            this.writeLine("public void set" + currentBean.className + "ScrollView(ScrollView<" + currentBean.basicViewBean.className + "> " + currentBean.objectName + "ScrollView) {");
            this.writeLine("this." + currentBean.objectName + "ScrollView = " + currentBean.objectName + "ScrollView;");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public ScrollForm<" + currentBean.basicViewBean.filterClassName + ", " + currentBean.basicViewBean.sortingClassName + "> get" + currentBean.className + "ScrollForm() {");
            this.writeLine("return " + currentBean.objectName + "ScrollForm;");
            this.writeLine("}");
            this.writeLine("public void set" + currentBean.className + "ScrollForm(ScrollForm<" + currentBean.basicViewBean.filterClassName + ", " + currentBean.basicViewBean.sortingClassName + "> " + currentBean.objectName + "ScrollForm) {");
            this.writeLine("this." + currentBean.objectName + "ScrollForm = " + currentBean.objectName + "ScrollForm;");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public " + currentBean.fullViewBean.className + " getSelected" + currentBean.className + "() {");
            this.writeLine("return selected" + currentBean.className + ";");
            this.writeLine("}");
            this.writeLine("public void setSelected" + currentBean.className + "(" + currentBean.fullViewBean.className + " selected" + currentBean.className + ") {");
            this.writeLine("this.selected" + currentBean.className + " = selected" + currentBean.className + ";");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            currentBean = oneToMany.referenceBean;
            this.writeLine("public ScrollView<" + currentBean.basicViewBean.className + "> get" + currentBean.className + "ScrollView() {");
            this.writeLine("return " + currentBean.objectName + "ScrollView;");
            this.writeLine("}");
            this.writeLine("public void set" + currentBean.className + "ScrollView(ScrollView<" + currentBean.basicViewBean.className + "> " + currentBean.objectName + "ScrollView) {");
            this.writeLine("this." + currentBean.objectName + "ScrollView = " + currentBean.objectName + "ScrollView;");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public ScrollForm<" + currentBean.basicViewBean.filterClassName + ", " + currentBean.basicViewBean.sortingClassName + "> get" + currentBean.className + "ScrollForm() {");
            this.writeLine("return " + currentBean.objectName + "ScrollForm;");
            this.writeLine("}");
            this.writeLine("public void set" + currentBean.className + "ScrollForm(ScrollForm<" + currentBean.basicViewBean.filterClassName + ", " + currentBean.basicViewBean.sortingClassName + "> " + currentBean.objectName + "ScrollForm) {");
            this.writeLine("this." + currentBean.objectName + "ScrollForm = " + currentBean.objectName + "ScrollForm;");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public " + currentBean.fullViewBean.className + " getSelected" + currentBean.className + "() {");
            this.writeLine("return selected" + currentBean.className + ";");
            this.writeLine("}");
            this.writeLine("public void setSelected" + currentBean.className + "(" + currentBean.fullViewBean.className + " selected" + currentBean.className + ") {");
            this.writeLine("this.selected" + currentBean.className + " = selected" + currentBean.className + ";");
            this.writeLine("}");
            this.skipLine();
        }
        this.writeNotOverridableContent();
        this.writeLine("}");
    }
}

