function setSelectionRange(input, selectionStart, selectionEnd) {
	if (input.setSelectionRange) {
		input.focus();
		input.setSelectionRange(selectionStart, selectionEnd);
	} else if (input.createTextRange) {
		var range = input.createTextRange();
		range.collapse(true);
		range.moveEnd('character', selectionEnd);
		range.moveStart('character', selectionStart);
		range.select();
	}
}

function setCaretToEnd(input) {
	setSelectionRange(input, input.value.length, input.value.length);
}


function displaySelectUnselectAll() {
	var checkbox = $("input[id$='selectUnselectAll']").get(0);	
	var elements = $("input[id$='selectUnselect']");
	
	bindSelectUnselectAll(checkbox, elements);
	
	if (elements.length == 0) {
		checkbox.checked = false;
		checkbox.style.display = "none";
	}
}

function selectUnselectAll(checkbox) {
	var elements = checkbox.form.elements;
	for ( var i = 0; i < elements.length; i++) {
		var element = elements[i];
		if (/selectUnselect$/.test(element.id)) {
			element.checked = checkbox.checked;
		}
	}
	if (checkbox.checked) {
		show('drop-list');
	} else {
		hide('drop-list');
	}
}

function selectUnselect(arg) {
	checkbox = document.getElementById(arg);
	var elements = checkbox.form.elements;
	
	bindSelectUnselectAll(checkbox, elements);	
}

function bindSelectUnselectAll(checkbox, elements) {
	var allSelected = true;
	var selectedItemNumber = 0;
	for (var elementIndex = 0; elementIndex < elements.length; elementIndex++) {
		var element = elements[elementIndex];
		if (/selectUnselect$/.test(element.id)) {
			if (!element.checked) {
				allSelected = false;
			} else {
				selectedItemNumber++;
			}
		}
	}
	checkbox.checked = allSelected;
	if (selectedItemNumber > 0) {
		show('drop-list');
	} else {
		hide('drop-list');
	}
}

function show(arg) {
	document.getElementById(arg).style.display = "block";
}

function hide(arg) {
	document.getElementById(arg).style.display = "none";
}


function onSuccess(args, callback) {
	if(!args.validationFailed && (!args.maximumSeverity || args.maximumSeverity.ordinal==0)) {
		callback();
	}
}