/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.commands.model;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.metadata.SelectionMode;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class JsfCommonViewFileWriteCommand
extends JavaFileWriteCommand {
    private Project project;

    public JsfCommonViewFileWriteCommand(Project project) {
        super(project.workspaceFolder + File.separator + project.projectName + "-webapp" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + project.model.mvcModelPackageName.replace(".", File.separator), "CommonView");
        this.project = project;
    }

    protected void fetchSpecificImports() {
        this.javaImports.add("import java.io.Serializable;");
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.ArrayList;");
        this.javaImports.add("import org.sklsft.commons.api.model.SelectItem;");
        this.javaImports.add("import org.springframework.stereotype.Component;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import org.springframework.context.annotation.Scope;");
        this.javaImports.add("import org.springframework.web.context.WebApplicationContext;");
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.project.model.mvcModelPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated common view class file");
        this.writeLine(" * <br/>used for select items");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("@Component");
        this.writeLine("@Scope(value=WebApplicationContext.SCOPE_SESSION)");
        this.writeLine("public class CommonView implements Serializable {");
        this.skipLine();
        this.writeLine("private static final long serialVersionUID = 1L;");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        for (Package myPackage : this.project.model.packages) {
            for (Bean bean : myPackage.beans) {
                if (!bean.selectable || !bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.DROPDOWN_OPTIONS)) continue;
                this.writeLine("private List<SelectItem>" + bean.objectName + "Options;");
            }
        }
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * getters and setters");
        this.writeLine(" */");
        for (Package myPackage : this.project.model.packages) {
            for (Bean bean : myPackage.beans) {
                if (!bean.selectable || !bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.DROPDOWN_OPTIONS)) continue;
                this.writeLine("public List<SelectItem> get" + bean.className + "Options() {");
                this.writeLine("return " + bean.objectName + "Options;");
                this.writeLine("}");
                this.writeLine("public void set" + bean.className + "Options(List<SelectItem> " + bean.objectName + "Options) {");
                this.writeLine("this." + bean.objectName + "Options = " + bean.objectName + "Options;");
                this.writeLine("}");
                this.skipLine();
            }
        }
        this.writeNotOverridableContent();
        this.writeLine("}");
    }
}

