/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.commands.controller;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.model.metadata.DetailMode;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class JsfBaseListControllerFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public JsfBaseListControllerFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-webapp" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseListControllerPackageName.replace(".", File.separator), bean.baseListControllerClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.ArrayList;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import org.sklsft.commons.mvc.ajax.AjaxMethodTemplate;");
        this.javaImports.add("import org.sklsft.commons.mvc.annotations.AjaxMethod;");
        this.javaImports.add("import org.sklsft.commons.api.exception.rights.OperationDeniedException;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollForm;");
        this.javaImports.add("import " + this.bean.myPackage.model.controllerPackageName + ".CommonController;");
        this.javaImports.add("import " + this.bean.myPackage.model.controllerPackageName + ".BaseController;");
        this.javaImports.add("import " + this.bean.myPackage.serviceInterfacePackageName + "." + this.bean.serviceInterfaceName + ";");
        this.javaImports.add("import " + this.bean.myPackage.listViewPackageName + "." + this.bean.listViewClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.filtersPackageName + "." + this.bean.basicViewBean.filterClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.sortingsPackageName + "." + this.bean.basicViewBean.sortingClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.basicViewsPackageName + "." + this.bean.basicViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.fullViewsPackageName + "." + this.bean.fullViewBean.className + ";");
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseListControllerPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base list controller class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.baseListControllerClassName + " extends BaseController {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * services injected by spring");
        this.writeLine(" */");
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.serviceInterfaceName + " " + this.bean.serviceObjectName + ";");
        this.writeLine("@Inject");
        this.writeLine("protected CommonController commonController;");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * view");
        this.writeLine(" */");
        this.writeLine("@Inject");
        this.writeLine("protected " + this.bean.listViewClassName + " " + this.bean.listViewObjectName + ";");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * getters and setters");
        this.writeLine(" */");
        this.writeLine("public " + this.bean.listViewClassName + " get" + this.bean.listViewClassName + "() {");
        this.writeLine("return " + this.bean.listViewObjectName + ";");
        this.writeLine("}");
        this.writeLine("public void set" + this.bean.listViewClassName + "(" + this.bean.listViewClassName + " " + this.bean.listViewObjectName + ") {");
        this.writeLine("this." + this.bean.listViewObjectName + " = " + this.bean.listViewObjectName + ";");
        this.writeLine("}");
        this.skipLine();
        this.createLoad();
        this.createCreateObject();
        this.createSaveObject();
        this.createEditObject();
        this.createUpdateObject();
        this.createDeleteObject();
        this.createDeleteObjectList();
        this.createResetFlters();
        this.writeLine("}");
    }

    private void createLoad() {
        this.writeLine("/**");
        this.writeLine(" * load object list");
        this.writeLine(" */");
        this.writeLine("public void load() {");
        this.writeLine("this.reset();");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * refresh object list");
        this.writeLine(" */");
        this.writeLine("public void refresh() {");
        this.writeLine(this.bean.listViewObjectName + ".setScrollView(" + this.bean.serviceObjectName + ".scroll(" + this.bean.listViewObjectName + ".getScrollForm()));");
        this.writeLine(this.bean.listViewObjectName + ".getScrollForm().setPage(" + this.bean.listViewObjectName + ".getScrollView().getCurrentPage());");
        this.writeLine("}");
        this.skipLine();
    }

    private void createCreateObject() {
        this.writeLine("/**");
        this.writeLine(" * create object");
        this.writeLine(" */");
        this.writeLine("public void create" + this.bean.className + "() {");
        for (ViewProperty property : this.bean.formBean.properties) {
            if (!property.isComboboxable() || !property.visibility.isDetailVisible()) continue;
            this.writeLine("this.commonController.load" + property.selectableBean.className + "Options();");
        }
        this.writeLine("try {");
        this.writeLine("this." + this.bean.listViewObjectName + ".setSelected" + this.bean.className + "(this." + this.bean.serviceObjectName + ".create());");
        this.writeLine("} catch (OperationDeniedException e) {");
        this.writeLine("displayError(e.getMessage());");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
    }

    private void createSaveObject() {
        this.writeLine("/**");
        this.writeLine(" * save object");
        this.writeLine(" */");
        if (this.bean.detailMode.equals((Object)DetailMode.MODAL)) {
            this.writeLine("@AjaxMethod(\"" + this.bean.className + ".save" + '\"' + ")");
            this.writeLine("public void save() {");
            this.writeLine(this.bean.serviceObjectName + ".save(this." + this.bean.listViewObjectName + ".getSelected" + this.bean.className + "().getForm());");
            this.writeLine("this.refresh();");
            this.writeLine("}");
            this.skipLine();
        } else {
            this.writeLine("public void save() {");
            this.writeLine("executeAjaxMethod(\"" + this.bean.className + ".save" + '\"' + ", new AjaxMethodTemplate() {");
            this.writeLine("@Override");
            this.writeLine("public Object execute() {");
            this.writeLine("return " + this.bean.serviceObjectName + ".save(" + this.bean.listViewObjectName + ".getSelected" + this.bean.className + "().getForm());");
            this.writeLine("}");
            this.writeLine("@Override");
            this.writeLine("public void redirectOnComplete(Object result) {");
            this.writeLine("redirect(\"/sections/" + this.bean.myPackage.urlPiece + "/" + this.bean.urlPiece + "/details.jsf?id=" + '\"' + " + result);");
            this.writeLine("}");
            this.writeLine("});");
            this.writeLine("}");
        }
    }

    private void createEditObject() {
        this.writeLine("/**");
        this.writeLine(" * edit object");
        this.writeLine(" */");
        this.writeLine("public void edit" + this.bean.className + "(" + this.bean.idType + " id) {");
        for (ViewProperty property : this.bean.formBean.properties) {
            if (!property.isComboboxable() || !property.visibility.isDetailVisible()) continue;
            this.writeLine("this.commonController.load" + property.selectableBean.className + "Options();");
        }
        this.writeLine(this.bean.listViewObjectName + ".setSelected" + this.bean.className + "(" + this.bean.serviceObjectName + ".load(id));");
        this.writeLine("}");
        this.skipLine();
    }

    private void createUpdateObject() {
        this.writeLine("/**");
        this.writeLine(" * update object");
        this.writeLine(" */");
        this.writeLine("@AjaxMethod(\"" + this.bean.className + ".update" + '\"' + ")");
        this.writeLine("public void update() {");
        this.writeLine(this.bean.serviceObjectName + ".update(this." + this.bean.listViewObjectName + ".getSelected" + this.bean.className + "().getId(), this." + this.bean.listViewObjectName + ".getSelected" + this.bean.className + "().getForm());");
        this.writeLine("this.refresh();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createDeleteObject() {
        this.writeLine("/**");
        this.writeLine(" * delete object");
        this.writeLine(" */");
        this.writeLine("@AjaxMethod(\"" + this.bean.className + ".delete" + '\"' + ")");
        this.writeLine("public void delete(" + this.bean.idType + " id) {");
        this.writeLine(this.bean.serviceObjectName + ".delete(id);");
        this.writeLine("this.refresh();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createDeleteObjectList() {
        this.writeLine("/**");
        this.writeLine(" * delete object list");
        this.writeLine(" */");
        this.writeLine("@AjaxMethod(\"" + this.bean.className + ".deleteList" + '\"' + ")");
        this.writeLine("public void deleteList() {");
        this.writeLine("List<" + this.bean.idType + "> ids = new ArrayList<>();");
        this.writeLine("for (" + this.bean.basicViewBean.className + " " + this.bean.objectName + ":" + this.bean.listViewObjectName + ".getScrollView().getElements()) {");
        this.writeLine("if (" + this.bean.objectName + ".getSelected()) {");
        this.writeLine("ids.add(" + this.bean.objectName + ".getId());");
        this.writeLine("}");
        this.writeLine("}");
        this.writeLine(this.bean.serviceObjectName + ".deleteList(ids);");
        this.writeLine("this.refresh();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createResetFlters() {
        this.writeLine("/**");
        this.writeLine(" * reset filters and sortings");
        this.writeLine(" */");
        this.writeLine("public void reset() {");
        this.writeLine("this." + this.bean.listViewObjectName + ".setScrollForm(new ScrollForm<>());");
        this.writeLine("this." + this.bean.listViewObjectName + ".getScrollForm().setFilter(new " + this.bean.basicViewBean.filterClassName + "());");
        this.writeLine("this." + this.bean.listViewObjectName + ".getScrollForm().setSorting(new " + this.bean.basicViewBean.sortingClassName + "());");
        this.writeLine("refresh();");
        this.writeLine("}");
        this.skipLine();
    }
}

