/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.layers;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToMany;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.skeletons.commands.impl.ResourcesFileWriteCommand;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.I18nFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.Richfaces4DetailMenuFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.Richfaces4DetailViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.Richfaces4ListViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.Richfaces4ModalViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.Richfaces4OneToManyComponentListViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.Richfaces4OneToManyComponentModalViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.Richfaces4OneToManyListViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.Richfaces4OneToManyModalViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.Richfaces4OneToOneComponentDetailViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.configuration.Richfaces4RootPomFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.configuration.Richfaces4SpringWebappFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.configuration.Richfaces4WebXmlFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4.configuration.Richfaces4WebappPomFileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class Richfaces4PresentationLayer
extends AbstractLayer {
    public Richfaces4PresentationLayer() {
        super("MVC Richfaces 4 presentation");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        FileWriteCommandTreeNode resourcesTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode copyResourcesTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new ResourcesFileWriteCommand(project, ((Object)((Object)this)).getClass(), "/richfaces4/src/", project.projectName + "-webapp"));
        resourcesTreeNode.add((MutableTreeNode)copyResourcesTreeNode);
        return resourcesTreeNode;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode rootPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4RootPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)rootPomTreeNode);
        FileWriteCommandTreeNode webappPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4WebappPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)webappPomTreeNode);
        FileWriteCommandTreeNode webXmlPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4WebXmlFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)webXmlPomTreeNode);
        FileWriteCommandTreeNode springWebappTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4SpringWebappFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)springWebappTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode presentationLayerTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode i18nTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new I18nFileWriteCommand(project));
        presentationLayerTreeNode.add((MutableTreeNode)i18nTreeNode);
        FileWriteCommandTreeNode listViewTreeNode = new FileWriteCommandTreeNode("List view files");
        presentationLayerTreeNode.add((MutableTreeNode)listViewTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            listViewTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4ListViewFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)beanTreeNode);
                FileWriteCommandTreeNode beanCreationTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4ModalViewFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)beanCreationTreeNode);
            }
        }
        FileWriteCommandTreeNode detailViewTreeNode = new FileWriteCommandTreeNode("Detail view files");
        presentationLayerTreeNode.add((MutableTreeNode)detailViewTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            detailViewTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                FileWriteCommandTreeNode componentListTreeNode;
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4DetailViewFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)beanTreeNode);
                FileWriteCommandTreeNode menuTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4DetailMenuFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)menuTreeNode);
                for (OneToManyComponent oneToManyComponent : bean.oneToManyComponentList) {
                    componentListTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4OneToManyComponentListViewFileWriteCommand(oneToManyComponent));
                    packageTreeNode.add((MutableTreeNode)componentListTreeNode);
                    FileWriteCommandTreeNode componentModalTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4OneToManyComponentModalViewFileWriteCommand(oneToManyComponent));
                    packageTreeNode.add((MutableTreeNode)componentModalTreeNode);
                }
                for (OneToMany oneToMany : bean.oneToManyList) {
                    componentListTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4OneToManyListViewFileWriteCommand(oneToMany));
                    packageTreeNode.add((MutableTreeNode)componentListTreeNode);
                    FileWriteCommandTreeNode componentCreationTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4OneToManyModalViewFileWriteCommand(oneToMany));
                    packageTreeNode.add((MutableTreeNode)componentCreationTreeNode);
                }
                for (OneToOneComponent uniqueComponent : bean.oneToOneComponentList) {
                    FileWriteCommandTreeNode componentTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new Richfaces4OneToOneComponentDetailViewFileWriteCommand(uniqueComponent));
                    packageTreeNode.add((MutableTreeNode)componentTreeNode);
                }
            }
        }
        return presentationLayerTreeNode;
    }
}

