/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.layers;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToMany;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.skeletons.commands.impl.ResourcesFileWriteCommand;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.I18nFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.PrimefacesDetailMenuFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.PrimefacesDetailViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.PrimefacesListViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.PrimefacesModalViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.PrimefacesOneToManyComponentListViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.PrimefacesOneToManyComponentModalViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.PrimefacesOneToManyListViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.PrimefacesOneToManyModalViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.PrimefacesOneToOneComponentDetailViewFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.configuration.PrimefacesRootPomFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.configuration.PrimefacesSpringWebappFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.configuration.PrimefacesWebXmlFileWriteCommand;
import org.sklsft.generator.skeletons.jsf.commands.presentation.primefaces.configuration.PrimefacesWebappPomFileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class PrimefacesPresentationLayer
extends AbstractLayer {
    public PrimefacesPresentationLayer() {
        super("MVC Primefaces presentation");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        FileWriteCommandTreeNode resourcesTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode copyResourcesTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new ResourcesFileWriteCommand(project, ((Object)((Object)this)).getClass(), "/primefaces/src/", project.projectName + "-webapp"));
        resourcesTreeNode.add((MutableTreeNode)copyResourcesTreeNode);
        return resourcesTreeNode;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode rootPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesRootPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)rootPomTreeNode);
        FileWriteCommandTreeNode webappPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesWebappPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)webappPomTreeNode);
        FileWriteCommandTreeNode webXmlPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesWebXmlFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)webXmlPomTreeNode);
        FileWriteCommandTreeNode springWebappTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesSpringWebappFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)springWebappTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode presentationLayerTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode i18nTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new I18nFileWriteCommand(project));
        presentationLayerTreeNode.add((MutableTreeNode)i18nTreeNode);
        FileWriteCommandTreeNode listViewTreeNode = new FileWriteCommandTreeNode("List view files");
        presentationLayerTreeNode.add((MutableTreeNode)listViewTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            listViewTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesListViewFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)beanTreeNode);
                FileWriteCommandTreeNode beanCreationTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesModalViewFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)beanCreationTreeNode);
            }
        }
        FileWriteCommandTreeNode detailViewTreeNode = new FileWriteCommandTreeNode("Detail view files");
        presentationLayerTreeNode.add((MutableTreeNode)detailViewTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            detailViewTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                FileWriteCommandTreeNode componentListTreeNode;
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesDetailViewFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)beanTreeNode);
                FileWriteCommandTreeNode menuTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesDetailMenuFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)menuTreeNode);
                for (OneToManyComponent oneToManyComponent : bean.oneToManyComponentList) {
                    componentListTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesOneToManyComponentListViewFileWriteCommand(oneToManyComponent));
                    packageTreeNode.add((MutableTreeNode)componentListTreeNode);
                    FileWriteCommandTreeNode componentModalTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesOneToManyComponentModalViewFileWriteCommand(oneToManyComponent));
                    packageTreeNode.add((MutableTreeNode)componentModalTreeNode);
                }
                for (OneToMany oneToMany : bean.oneToManyList) {
                    componentListTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesOneToManyListViewFileWriteCommand(oneToMany));
                    packageTreeNode.add((MutableTreeNode)componentListTreeNode);
                    FileWriteCommandTreeNode componentCreationTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesOneToManyModalViewFileWriteCommand(oneToMany));
                    packageTreeNode.add((MutableTreeNode)componentCreationTreeNode);
                }
                for (OneToOneComponent uniqueComponent : bean.oneToOneComponentList) {
                    FileWriteCommandTreeNode componentTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PrimefacesOneToOneComponentDetailViewFileWriteCommand(uniqueComponent));
                    packageTreeNode.add((MutableTreeNode)componentTreeNode);
                }
            }
        }
        return presentationLayerTreeNode;
    }
}

