/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.commands.presentation.richfaces4;

import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.ui.ViewProperty;
import org.sklsft.generator.model.metadata.DataType;
import org.sklsft.generator.model.metadata.SelectionMode;
import org.sklsft.generator.skeletons.commands.impl.typed.XhtmlFileWriteCommand;

public abstract class Richfaces4XhtmlFileWriteCommand
extends XhtmlFileWriteCommand {
    public Richfaces4XhtmlFileWriteCommand(String folderName, String fileName) {
        super(folderName, fileName);
    }

    protected void writeListComponent(ViewProperty property, Bean bean) {
        switch (property.dataType) {
            case BOOLEAN: {
                if (property.nullable) {
                    this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}\"/>");
                    break;
                }
                this.writeLine("<h:selectBooleanCheckbox value=\"#{" + bean.objectName + "." + property.name + "}\" disabled=\"true\"/>");
                break;
            }
            case DATE: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}\">");
                this.writeLine("<f:convertDateTime pattern=\"yyyy-MM-dd\"/>");
                this.writeLine("</h:outputText>");
                break;
            }
            case DATETIME: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}\">");
                this.writeLine("<f:convertDateTime pattern=\"yyyy-MM-dd HH:mm:ss\"/>");
                this.writeLine("</h:outputText>");
                break;
            }
            case DOUBLE: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}\">");
                this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
                this.writeLine("</h:outputText>");
                break;
            }
            case BIG_DECIMAL: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}\">");
                this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
                this.writeLine("</h:outputText>");
                break;
            }
            case LONG: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}\">");
                this.writeLine("<f:convertNumber pattern=\"#,##0\"/>");
                this.writeLine("</h:outputText>");
                break;
            }
            case STRING: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}\"/>");
                break;
            }
            case TEXT: {
                this.writeLine("<pre class=\"truncated-text\"");
                this.writeLine(" data-toggle=\"tooltip\"");
                this.writeLine(" data-html=\"true\"");
                this.writeLine(" data-title='&lt;pre&gt;#{" + bean.objectName + "." + property.name + "}&lt;/pre&gt;'");
                this.writeLine(" data-placement=\"bottom\"");
                this.writeLine(" data-trigger=\"click\">");
                this.writeLine("#{" + bean.objectName + "." + property.name + "}");
                this.writeLine("</pre>");
            }
        }
    }

    protected void writeInput(ViewProperty property, Bean bean) {
        this.writeInput("", property, bean);
    }

    protected void writeInput(String prefix, ViewProperty property, Bean bean) {
        this.writeLine("<div class=\"col-xs-12\">");
        if (!property.dataType.equals((Object)DataType.BOOLEAN)) {
            this.writeLine("<label>#{i18n." + bean.objectName + property.capName + "}</label>");
        }
        if (property.selectableBean != null) {
            if (property.selectableBean.selectionBehavior.selectionMode.equals((Object)SelectionMode.DROPDOWN_OPTIONS)) {
                this.writeCombobox(prefix, property, bean);
            } else {
                this.writeAutocomplete(prefix, property, bean);
            }
        } else {
            switch (property.dataType) {
                case BOOLEAN: {
                    this.writeBooleanInput(prefix, property, bean);
                    break;
                }
                case DATE: {
                    this.writeDateInput(prefix, property, bean);
                    break;
                }
                case DATETIME: {
                    this.writeDateTimeInput(prefix, property, bean);
                    break;
                }
                case DOUBLE: {
                    this.writeDoubleInput(prefix, property, bean);
                    break;
                }
                case BIG_DECIMAL: {
                    this.writeBigDecimalInput(prefix, property, bean);
                    break;
                }
                case LONG: {
                    this.writeLongInput(prefix, property, bean);
                    break;
                }
                case STRING: {
                    this.writeStringInput(prefix, property, bean);
                    break;
                }
                case TEXT: {
                    this.writeTextInput(prefix, property, bean);
                }
            }
        }
        if (!property.dataType.equals((Object)DataType.BOOLEAN)) {
            this.writeLine("<h:message for=\"" + prefix + bean.objectName + property.capName + "\" styleClass=\"detail-error-message\"/>");
        }
        this.writeLine("</div>");
        this.skipLine();
    }

    private void writeCombobox(String prefix, ViewProperty property, Bean bean) {
        this.write("<h:selectOneMenu id=\"" + prefix + bean.objectName + property.capName + "\" styleClass=\"form-control\" value=\"#{form." + property.name + "}\"");
        if (!property.editable) {
            this.write(" disabled=\"true\"");
        }
        this.writeLine(">");
        this.writeLine("<f:selectItem itemValue=\"#{null}\" itemLabel=\"\"/>");
        this.writeLine("<f:selectItems value=\"#{commonView." + property.selectableBean.objectName + "Options}\"");
        this.writeLine("var=\"option\" itemValue=\"#{option.key}\" itemLabel=\"#{option.label}\"/>");
        this.writeLine("</h:selectOneMenu>");
    }

    private void writeAutocomplete(String prefix, ViewProperty property, Bean bean) {
        this.writeLine("<rich:autocomplete id=\"" + prefix + bean.objectName + property.capName + "\" styleClass=\"form-control\" value=\"#{form." + property.name + "}\"");
        if (!property.editable) {
            this.write(" disabled=\"true\"");
        }
        this.writeLine(" autocompleteMethod=\"#{commonController.search" + property.selectableBean.className + "Options}\"/>");
    }

    private void writeStringInput(String prefix, ViewProperty property, Bean bean) {
        this.write("<h:inputText id=\"" + prefix + bean.objectName + property.capName + "\" styleClass=\"form-control\" value=\"#{form." + property.name + "}\"");
        if (!property.editable) {
            this.write(" disabled=\"true\"");
        }
        this.writeLine("/>");
    }

    private void writeTextInput(String prefix, ViewProperty property, Bean bean) {
        this.write("<h:inputTextarea id=\"" + prefix + bean.objectName + property.capName + "\" styleClass=\"form-control\" rows=\"10\" value=\"#{form." + property.name + "}\"");
        if (!property.editable) {
            this.write(" disabled=\"true\"");
        }
        this.writeLine("/>");
    }

    private void writeBooleanInput(String prefix, ViewProperty property, Bean bean) {
        this.writeLine("<div class=\"checkbox\">");
        this.writeLine("<label>");
        this.writeLine("<h:selectBooleanCheckbox id=\"" + prefix + bean.objectName + property.capName + "\" value=\"#{form." + property.name + "}\"");
        if (property.editable) {
            this.writeLine("readonly=\"false\" disabled=\"false\"/>");
        } else {
            this.writeLine("readonly=\"true\" disabled=\"true\"/>");
        }
        this.writeLine("#{i18n." + bean.objectName + property.capName + "}");
        this.writeLine("</label>");
        this.writeLine("</div>");
    }

    private void writeDoubleInput(String prefix, ViewProperty property, Bean bean) {
        this.write("<h:inputText id=\"" + prefix + bean.objectName + property.capName + "\" styleClass=\"form-control\" value=\"#{form." + property.name + "}\"");
        if (!property.editable) {
            this.write(" disabled=\"true\"");
        }
        this.writeLine(">");
        this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
        this.writeLine("</h:inputText>");
    }

    private void writeBigDecimalInput(String prefix, ViewProperty property, Bean bean) {
        this.write("<h:inputText id=\"" + prefix + bean.objectName + property.capName + "\" styleClass=\"form-control\" value=\"#{form." + property.name + "}\"");
        if (!property.editable) {
            this.write(" disabled=\"true\"");
        }
        this.writeLine(">");
        this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
        this.writeLine("</h:inputText>");
    }

    private void writeLongInput(String prefix, ViewProperty property, Bean bean) {
        this.write("<h:inputText id=\"" + prefix + bean.objectName + property.capName + "\" styleClass=\"form-control\" value=\"#{form." + property.name + "}\"");
        if (!property.editable) {
            this.skipLine();
            this.write("disabled=\"true\"");
        }
        this.writeLine(">");
        this.writeLine("<f:convertNumber integerOnly=\"true\" pattern=\"#,##0\"/>");
        this.writeLine("</h:inputText>");
    }

    private void writeDateInput(String prefix, ViewProperty property, Bean bean) {
        this.writeLine("<rich:calendar id=\"" + prefix + bean.objectName + property.capName + "\" inputClass=\"form-control\" value=\"#{form." + property.name + "}\"");
        this.write(" datePattern=\"yyyy-MM-dd\"");
        if (!property.editable) {
            this.skipLine();
            this.write("disabled=\"true\"");
        }
        this.writeLine("/>");
    }

    private void writeDateTimeInput(String prefix, ViewProperty property, Bean bean) {
        this.writeLine("<rich:calendar id=\"" + prefix + bean.objectName + property.capName + "\" inputClass=\"form-control\" value=\"#{form." + property.name + "}\"");
        this.write(" datePattern=\"yyyy-MM-dd HH:mm:ss\"");
        if (!property.editable) {
            this.skipLine();
            this.write("disabled=\"true\"");
        }
        this.writeLine("/>");
    }

    protected void writeFilter(ViewProperty property, Bean bean, Bean parentBean) {
        this.writeLine("<label>#{i18n." + bean.objectName + property.capName + "}</label>");
        String scrollForm = parentBean != null ? parentBean.detailViewObjectName + "." + bean.objectName + "ScrollForm" : bean.listViewObjectName + ".scrollForm";
        String refreshMethod = parentBean != null ? parentBean.detailControllerObjectName + ".refresh" + bean.className + "List" : bean.listControllerObjectName + ".refresh";
        switch (property.dataType) {
            case STRING: 
            case TEXT: {
                this.writeLine("<h:inputText");
                this.writeLine("value=\"#{" + scrollForm + ".filter." + property.name + "}\"");
                this.writeLine("styleClass=\"form-control\">");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\"/>");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
                break;
            }
            case DATE: {
                this.writeLine("<rich:calendar value=\"#{" + scrollForm + ".filter." + property.name + "MinValue}\"");
                this.writeLine("inputClass=\"form-control\"");
                this.writeLine("datePattern=\"yyyy-MM-dd\">");
                this.writeLine("<a4j:ajax event=\"change\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</rich:calendar>");
                this.writeLine("<rich:calendar value=\"#{" + scrollForm + ".filter." + property.name + "MaxValue}\"");
                this.writeLine("inputClass=\"form-control\"");
                this.writeLine("datePattern=\"yyyy-MM-dd\">");
                this.writeLine("<a4j:ajax event=\"change\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</rich:calendar>");
                break;
            }
            case DATETIME: {
                this.writeLine("<rich:calendar value=\"#{" + scrollForm + ".filter." + property.name + "MinValue}\"");
                this.writeLine("inputClass=\"form-control\"");
                this.writeLine("datePattern=\"yyyy-MM-dd HH:mm:ss\">");
                this.writeLine("<a4j:ajax event=\"change\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</rich:calendar>");
                this.writeLine("<rich:calendar value=\"#{" + scrollForm + ".filter." + property.name + "MaxValue}\"");
                this.writeLine("inputClass=\"form-control\"");
                this.writeLine("datePattern=\"yyyy-MM-dd HH:mm:ss\">");
                this.writeLine("<a4j:ajax event=\"change\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</rich:calendar>");
                break;
            }
            case DOUBLE: {
                this.writeLine("<h:inputText value=\"#{" + scrollForm + ".filter." + property.name + "MinValue}\"");
                this.writeLine("styleClass=\"form-control\">");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\"/>");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
                this.writeLine("<h:inputText value=\"#{" + scrollForm + ".filter." + property.name + "MaxValue}\"");
                this.writeLine("styleClass=\"form-control\">");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\"/>");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
                break;
            }
            case BIG_DECIMAL: {
                this.writeLine("<h:inputText value=\"#{" + scrollForm + ".filter." + property.name + "MinValue}\"");
                this.writeLine("styleClass=\"form-control\">");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\"/>");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
                this.writeLine("<h:inputText value=\"#{" + scrollForm + ".filter." + property.name + "MaxValue}\"");
                this.writeLine("styleClass=\"form-control\">");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\"/>");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
                break;
            }
            case LONG: {
                this.writeLine("<h:inputText value=\"#{" + scrollForm + ".filter." + property.name + "MinValue}\"");
                this.writeLine("styleClass=\"form-control\">");
                this.writeLine("<f:convertNumber integerOnly=\"true\" pattern=\"#,##0\"/>");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\"/>");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
                this.writeLine("<h:inputText value=\"#{" + scrollForm + ".filter." + property.name + "MaxValue}\"");
                this.writeLine("styleClass=\"form-control\">");
                this.writeLine("<f:convertNumber integerOnly=\"true\" pattern=\"#,##0\"/>");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\"/>");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
                break;
            }
            case BOOLEAN: {
                this.writeLine("<h:selectOneMenu value=\"#{" + scrollForm + ".filter." + property.name + "}\" styleClass=\"form-control\">");
                this.writeLine("<f:selectItem itemLabel=\"\" itemValue=\"#{null}\"></f:selectItem>");
                this.writeLine("<f:selectItem itemLabel=\"#{i18n.trueLabel}\" itemValue=\"#{true}\"></f:selectItem>");
                this.writeLine("<f:selectItem itemLabel=\"#{i18n.falseLabel}\" itemValue=\"#{false}\"></f:selectItem>");
                this.writeLine("<a4j:ajax event=\"change\" render=\"resultsPanelGroup\" listener=\"#{" + refreshMethod + "}\">");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:selectOneMenu>");
            }
        }
    }

    protected void writeFilter(ViewProperty property, Bean bean) {
        this.writeFilter(property, bean, null);
    }
}

