/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.commands.model;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class MvcListViewFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public MvcListViewFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-webapp" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.listViewPackageName.replace(".", File.separator), bean.listViewClassName);
        this.bean = bean;
    }

    protected void fetchSpecificImports() {
        this.javaImports.add("import java.io.Serializable;");
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollForm;");
        this.javaImports.add("import org.sklsft.commons.api.model.ScrollView;");
        this.javaImports.add("import org.springframework.stereotype.Component;");
        this.javaImports.add("import org.springframework.context.annotation.Scope;");
        this.javaImports.add("import org.springframework.web.context.WebApplicationContext;");
        this.javaImports.add("import " + this.bean.myPackage.basicViewsPackageName + "." + this.bean.basicViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.filtersPackageName + "." + this.bean.basicViewBean.filterClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.sortingsPackageName + "." + this.bean.basicViewBean.sortingClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.fullViewsPackageName + "." + this.bean.fullViewBean.className + ";");
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.listViewPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated list view class file");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("@Component");
        this.writeLine("@Scope(value=WebApplicationContext.SCOPE_SESSION)");
        this.writeLine("public class " + this.bean.listViewClassName + " implements Serializable {");
        this.skipLine();
        this.writeLine("private static final long serialVersionUID = 1L;");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        this.writeLine("protected ScrollForm<" + this.bean.basicViewBean.filterClassName + ", " + this.bean.basicViewBean.sortingClassName + "> scrollForm = new ScrollForm<>();");
        this.writeLine("protected ScrollView<" + this.bean.basicViewBean.className + "> scrollView = new ScrollView<>();");
        this.writeLine("protected " + this.bean.fullViewBean.className + " selected" + this.bean.className + ";");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * getters and setters");
        this.writeLine(" */");
        this.writeLine("public ScrollView<" + this.bean.basicViewBean.className + "> getScrollView() {");
        this.writeLine("return scrollView;");
        this.writeLine("}");
        this.writeLine("public void setScrollView(ScrollView<" + this.bean.basicViewBean.className + "> scrollView) {");
        this.writeLine("this.scrollView = scrollView;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("public ScrollForm<" + this.bean.basicViewBean.filterClassName + ", " + this.bean.basicViewBean.sortingClassName + "> getScrollForm() {");
        this.writeLine("return scrollForm;");
        this.writeLine("}");
        this.writeLine("public void setScrollForm(ScrollForm<" + this.bean.basicViewBean.filterClassName + ", " + this.bean.basicViewBean.sortingClassName + "> scrollForm) {");
        this.writeLine("this.scrollForm = scrollForm;");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("public " + this.bean.fullViewBean.className + " getSelected" + this.bean.className + "() {");
        this.writeLine("return selected" + this.bean.className + ";");
        this.writeLine("}");
        this.writeLine("public void setSelected" + this.bean.className + "(" + this.bean.fullViewBean.className + " selected" + this.bean.className + ") {");
        this.writeLine("this.selected" + this.bean.className + " = selected" + this.bean.className + ";");
        this.writeLine("}");
        this.skipLine();
        this.writeNotOverridableContent();
        this.writeLine("}");
    }
}

