/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.jsf.commands.controller;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.metadata.SelectionMode;
import org.sklsft.generator.skeletons.commands.impl.typed.JavaFileWriteCommand;

public class JsfCommonControllerFileWriteCommand
extends JavaFileWriteCommand {
    private Project project;

    public JsfCommonControllerFileWriteCommand(Project project) {
        super(project.workspaceFolder + File.separator + project.projectName + "-webapp" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + project.model.controllerPackageName.replace(".", File.separator), "CommonController");
        this.project = project;
    }

    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.ArrayList;");
        this.javaImports.add("import org.sklsft.commons.api.model.SelectItem;");
        this.javaImports.add("import org.springframework.stereotype.Component;");
        this.javaImports.add("import javax.inject.Inject;");
        this.javaImports.add("import org.springframework.context.annotation.Scope;");
        this.javaImports.add("import org.springframework.web.context.WebApplicationContext;");
        this.javaImports.add("import " + this.project.model.mvcModelPackageName + ".CommonView;");
        for (Package myPackage : this.project.model.packages) {
            for (Bean bean : myPackage.beans) {
                if (!bean.selectable) continue;
                this.javaImports.add("import " + bean.myPackage.serviceInterfacePackageName + "." + bean.serviceInterfaceName + ";");
            }
        }
    }

    protected void writeContent() throws IOException {
        this.writeLine("package " + this.project.model.controllerPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated common controller class file");
        this.writeLine(" * <br/>used for loading select items");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("@Component");
        this.writeLine("@Scope(value=WebApplicationContext.SCOPE_REQUEST)");
        this.writeLine("public class CommonController {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * the view handled by the controller");
        this.writeLine(" */");
        this.writeLine("@Inject");
        this.writeLine("private CommonView commonView;");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * the services used by the controller");
        this.writeLine(" */");
        for (Package myPackage : this.project.model.packages) {
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent || !bean.selectable) continue;
                this.writeLine("@Inject");
                this.writeLine("private " + bean.serviceInterfaceName + " " + bean.serviceObjectName + ";");
            }
        }
        this.skipLine();
        for (Package myPackage : this.project.model.packages) {
            for (Bean bean : myPackage.beans) {
                if (!bean.selectable) continue;
                if (bean.selectionBehavior.selectionMode.equals((Object)SelectionMode.DROPDOWN_OPTIONS)) {
                    this.writeLine("/**");
                    this.writeLine(" * load options for " + bean.className);
                    this.writeLine(" */");
                    this.writeLine("public void load" + bean.className + "Options() {");
                    this.writeLine("List<SelectItem> options = this." + bean.serviceObjectName + ".getOptions();");
                    this.writeLine("this.commonView.set" + bean.className + "Options(options);");
                    this.writeLine("}");
                    this.skipLine();
                    continue;
                }
                this.writeLine("/**");
                this.writeLine(" * search options for " + bean.className);
                this.writeLine(" */");
                this.writeLine("public List<String> search" + bean.className + "Options(String arg) {");
                this.writeLine("List<SelectItem> options = this." + bean.serviceObjectName + ".searchOptions(arg);");
                this.writeLine("List<String> result = new ArrayList<>(options.size());");
                this.writeLine("for (SelectItem option : options) {");
                this.writeLine("result.add(option.getKey());");
                this.writeLine("}");
                this.writeLine("return result;");
                this.writeLine("}");
                this.skipLine();
            }
        }
        this.writeNotOverridableContent();
        this.writeLine("}");
    }
}

