/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bash.prompt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.sklsft.generator.bash.arguments.BasicFreeChoicesHelper;
import org.sklsft.generator.bash.arguments.ChoicesHelper;
import org.sklsft.generator.bash.arguments.DatabaseEngineChoicesHelper;
import org.sklsft.generator.bash.arguments.SkeletonChoicesHelper;
import org.sklsft.generator.bash.arguments.TrueFalseChoicesHelper;
import org.sklsft.generator.bash.prompt.ArgumentsPrompter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectInitializerPrompter
implements ArgumentsPrompter {
    private static final Logger logger = LoggerFactory.getLogger(ProjectInitializerPrompter.class);
    private List<ChoicesHelper> choicesHelpers = new ArrayList<ChoicesHelper>();
    private List<ChoicesHelper> datasourceChoicesHelpers = new ArrayList<ChoicesHelper>();

    public ProjectInitializerPrompter() {
        this.choicesHelpers.add(new BasicFreeChoicesHelper("Enter your domain name  (ex:org.sklsft) : "));
        this.choicesHelpers.add(new BasicFreeChoicesHelper("Enter your project name (ex:demo) : "));
        this.choicesHelpers.add(new SkeletonChoicesHelper());
        this.choicesHelpers.add(new DatabaseEngineChoicesHelper());
        this.choicesHelpers.add(new TrueFalseChoicesHelper("Do you want to activate Hibernate envers fonctionality "));
        this.datasourceChoicesHelpers.add(new BasicFreeChoicesHelper("Enter your database name (ex:DEMO) : "));
        this.datasourceChoicesHelpers.add(new BasicFreeChoicesHelper("Enter your database host name (ex:localhost) : "));
        this.datasourceChoicesHelpers.add(new BasicFreeChoicesHelper("Enter your database port (ex:5432) : "));
        this.datasourceChoicesHelpers.add(new BasicFreeChoicesHelper("Enter your database username (ex:postgres) : "));
        this.datasourceChoicesHelpers.add(new BasicFreeChoicesHelper("Enter your database password (ex:postgres) : "));
    }

    @Override
    public List<String> promptForArguments() {
        String argument = null;
        ArrayList<String> arguments = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));){
            String input;
            for (ChoicesHelper helper : this.choicesHelpers) {
                argument = null;
                while (argument == null) {
                    System.out.println(helper.getFullMessage());
                    input = bufferedReader.readLine();
                    argument = helper.getChoice(input);
                }
                arguments.add(argument);
            }
            for (ChoicesHelper helper : this.datasourceChoicesHelpers) {
                argument = null;
                while (argument == null) {
                    System.out.println(helper.getFullMessage());
                    input = bufferedReader.readLine();
                    argument = helper.getChoice(input);
                }
                arguments.add(argument);
            }
            System.out.println("domain name : " + (String)arguments.get(0));
            System.out.println("project name : " + (String)arguments.get(1));
            System.out.println("skeleton type : " + (String)arguments.get(2));
            System.out.println("database engine : " + (String)arguments.get(3));
            System.out.println("hibernate envers activated : " + (String)arguments.get(4));
            System.out.println("database name : " + (String)arguments.get(5));
            System.out.println("database host name : " + (String)arguments.get(6));
            System.out.println(" port : " + (String)arguments.get(7));
            System.out.println("database username : " + (String)arguments.get(8));
            System.out.println("database password : " + (String)arguments.get(9));
            System.out.println("Please confirm your choice (Y/n)");
            input = bufferedReader.readLine();
            if (!"Y".equals(input)) {
                System.exit(0);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return arguments;
    }
}

