/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bash.launcher;

import org.sklsft.generator.bl.services.interfaces.CodeGenerator;
import org.sklsft.generator.bl.services.interfaces.ProjectLoader;
import org.sklsft.generator.bl.services.interfaces.ProjectMetaDataService;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.metadata.PersistenceMode;
import org.sklsft.generator.model.metadata.ProjectMetaData;
import org.sklsft.generator.model.metadata.datasources.DataSourceMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ProjectInitializerLauncher {
    private static final Logger logger = LoggerFactory.getLogger(ProjectInitializerLauncher.class);

    public static void main(String[] args) {
        if (args.length < 11) {
            throw new IllegalArgumentException("11 arguments are mandatory");
        }
        try (FileSystemXmlApplicationContext appContext = new FileSystemXmlApplicationContext("classpath:applicationContext-generator-bash.xml");){
            Project project;
            logger.info("Context loaded");
            ProjectMetaData projectMetaData = ProjectInitializerLauncher.buildProjectMetaData(args);
            DataSourceMetaData datasource = ProjectInitializerLauncher.buildDataSource(args);
            projectMetaData.setDataSource(datasource);
            CodeGenerator codeGenerator = (CodeGenerator)appContext.getBean(CodeGenerator.class);
            try {
                logger.info("start persisting project");
                ProjectMetaDataService projectMetaDataService = (ProjectMetaDataService)appContext.getBean(ProjectMetaDataService.class);
                projectMetaDataService.initProjectMetaData(projectMetaData);
                logger.info("persisting project completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var2_2 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
            try {
                logger.info("start loading project");
                ProjectLoader projectLoader = (ProjectLoader)appContext.getBean(ProjectLoader.class);
                project = projectLoader.loadProject(projectMetaData);
                logger.info("loading project " + project.projectName + " completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var2_2 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
            try {
                logger.info("start copying resources");
                codeGenerator.initResources(project);
                logger.info("copying resources completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var2_2 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
            try {
                logger.info("start writing configuration");
                codeGenerator.initConfiguration(project);
                logger.info("writing configuration completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var2_2 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
        }
    }

    private static ProjectMetaData buildProjectMetaData(String[] args) {
        ProjectMetaData projectMetaData = new ProjectMetaData();
        projectMetaData.setPersistenceMode(PersistenceMode.XML);
        projectMetaData.setWorkspaceFolder(args[0]);
        projectMetaData.setDomainName(args[1]);
        projectMetaData.setProjectName(args[2]);
        projectMetaData.setSkeleton(args[3]);
        projectMetaData.setDatabaseEngine(args[4]);
        projectMetaData.setAudited(Boolean.valueOf(args[5]).booleanValue());
        return projectMetaData;
    }

    private static DataSourceMetaData buildDataSource(String[] args) {
        DataSourceMetaData result = new DataSourceMetaData();
        result.setDatabaseName(args[6]);
        result.setHost(args[7]);
        result.setPort(args[8]);
        result.setUserName(args[9]);
        result.setPassword(args[10]);
        return result;
    }
}

