/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bash.launcher;

import java.io.File;
import org.apache.commons.dbcp.BasicDataSource;
import org.sklsft.generator.bash.prompt.ValidationPrompter;
import org.sklsft.generator.bl.services.interfaces.DatabaseBuilder;
import org.sklsft.generator.bl.services.interfaces.ProjectLoader;
import org.sklsft.generator.bl.services.interfaces.ProjectMetaDataService;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.metadata.ProjectMetaData;
import org.sklsft.generator.model.metadata.validation.ProjectValidationReport;
import org.sklsft.generator.persistence.backup.datasource.interfaces.OutputDataSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class DatabaseBuilderLauncher {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseBuilderLauncher.class);
    private static final String DATASOURCE_CONTEXT_FILE = "datasource-context.xml";

    public static void main(String[] args) {
        if (args.length < 2) {
            throw new IllegalArgumentException("Path and datasource are Mandatory");
        }
        String workspacePath = args[0];
        String databaseName = args[1];
        String sourcePath = workspacePath + File.separator + "data-model";
        try (FileSystemXmlApplicationContext appContext = new FileSystemXmlApplicationContext(new String[]{"classpath:applicationContext-generator-bash.xml", "file:" + sourcePath + File.separator + DATASOURCE_CONTEXT_FILE});){
            Project project;
            logger.info("Context loaded");
            try {
                logger.info("start loading project");
                ProjectMetaDataService projectMetaDataService = (ProjectMetaDataService)appContext.getBean(ProjectMetaDataService.class);
                ProjectLoader projectLoader = (ProjectLoader)appContext.getBean(ProjectLoader.class);
                ProjectMetaData projectMetaData = projectMetaDataService.loadProjectMetaData(workspacePath);
                ProjectValidationReport report = projectMetaDataService.validate(projectMetaData);
                ValidationPrompter.promptOnValidation(report);
                project = projectLoader.loadProject(projectMetaData);
                logger.info("loading project " + project.projectName + " completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var5_5 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable projectLoader) {
                            var5_5.addSuppressed(projectLoader);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
            try {
                OutputDataSourceProvider outputDataSourceProvider = (OutputDataSourceProvider)appContext.getBean(OutputDataSourceProvider.class);
                BasicDataSource dataSource = outputDataSourceProvider.getDataSource(databaseName);
                DatabaseBuilder databaseBuilder = (DatabaseBuilder)appContext.getBean(DatabaseBuilder.class);
                databaseBuilder.buildDatabase(dataSource, project);
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var5_5 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
        }
    }
}

