/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bash.arguments;

import java.util.Map;
import java.util.SortedMap;
import org.sklsft.generator.bash.arguments.ChoicesHelper;

public abstract class AbstractMultiChoicesHelper
implements ChoicesHelper {
    protected SortedMap<String, String> choices;
    private boolean initialized = false;

    protected abstract void initialize();

    public SortedMap<String, String> getChoices() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        return this.choices;
    }

    @Override
    public String getChoice(String key) {
        return (String)this.getChoices().get(key);
    }

    public String getChoicesDisplaying() {
        if (this.getChoices().entrySet().isEmpty()) {
            throw new IllegalStateException("This class must be used with several choices");
        }
        String result = " (";
        boolean start = true;
        for (Map.Entry<String, String> entry : this.getChoices().entrySet()) {
            if (start) {
                start = false;
            } else {
                result = result + ", ";
            }
            result = result + entry.getKey() + ":" + entry.getValue();
        }
        result = result + ") :";
        return result;
    }

    protected abstract String getQuestion();

    @Override
    public String getFullMessage() {
        String result = this.getQuestion();
        result = result + this.getChoicesDisplaying();
        return result;
    }
}

