/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.model.metadata;

import java.util.HashMap;
import java.util.Map;

public enum PersistenceMode {
    CSV(".txt"),
    XML(".xml"),
    CMD(".raw");

    private static final Map<String, PersistenceMode> reverseMap;
    private String extension;

    private PersistenceMode(String value) {
        this.extension = value;
    }

    public String getExtension() {
        return this.extension;
    }

    public static PersistenceMode byExtension(String value) {
        PersistenceMode persistenceMode = reverseMap.get(value);
        if (persistenceMode == null) {
            throw new IllegalArgumentException("No PersistenceMode corresponding to value " + value);
        }
        return persistenceMode;
    }

    static {
        reverseMap = new HashMap<String, PersistenceMode>();
        for (PersistenceMode skeletonType : PersistenceMode.values()) {
            reverseMap.put(skeletonType.getExtension(), skeletonType);
        }
    }
}

