/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.model.domain.database;

import java.util.ArrayList;
import java.util.List;
import org.sklsft.generator.exception.PropertyNotFoundException;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.domain.database.UniqueConstraint;

public class Table {
    public Package myPackage;
    public String name;
    public String originalName;
    public int cardinality;
    public List<Column> columns = new ArrayList<Column>();
    public List<UniqueConstraint> uniqueConstraints = new ArrayList<UniqueConstraint>();

    public Column findColumnByName(String columnName) {
        for (Column column : this.columns) {
            if (!column.originalName.equals(columnName)) continue;
            return column;
        }
        throw new PropertyNotFoundException("Column : " + columnName + " not found");
    }

    public List<Column> getFindColumnList() {
        ArrayList<Column> findColumnList = new ArrayList<Column>();
        List<Object> tempColumnList = new ArrayList();
        for (int i = 1; i <= this.cardinality; ++i) {
            if (this.columns.get((int)i).referenceTable != null) {
                tempColumnList = this.columns.get((int)i).referenceTable.getFindColumnList();
                for (int j = 0; j < tempColumnList.size(); ++j) {
                    Column column = new Column();
                    column.name = this.columns.get((int)i).name.replace("_ID", "_").replace("_id", "_") + ((Column)tempColumnList.get((int)j)).name;
                    column.dataType = ((Column)tempColumnList.get((int)j)).dataType;
                    column.nullable = this.columns.get((int)i).nullable;
                    findColumnList.add(column);
                }
                continue;
            }
            Column column = new Column();
            column.name = this.columns.get((int)i).name;
            column.dataType = this.columns.get((int)i).dataType;
            column.nullable = this.columns.get((int)i).nullable;
            findColumnList.add(column);
        }
        return findColumnList;
    }

    public List<Column> getInsertColumnList() {
        ArrayList<Column> result = new ArrayList<Column>();
        List<Object> tempColumnList = new ArrayList();
        for (Column currentColumn : this.columns) {
            if (currentColumn.referenceTable != null) {
                tempColumnList = currentColumn.referenceTable.getFindColumnList();
                for (Column column : tempColumnList) {
                    Column column2 = new Column();
                    column2.name = currentColumn.name.replace("_ID", "_").replace("_id", "_") + column.name;
                    column2.dataType = column.dataType;
                    column2.nullable = currentColumn.nullable;
                    result.add(column2);
                }
                continue;
            }
            Column column = new Column();
            column.name = currentColumn.name;
            column.dataType = currentColumn.dataType;
            column.nullable = currentColumn.nullable;
            result.add(column);
        }
        return result;
    }
}

