/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.tree;

import org.apache.commons.lang.StringUtils;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriteCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(FileWriteCommandExecutor.class);
    private FileWriteCommand command;
    private boolean selected;
    private String label;

    public FileWriteCommandExecutor(FileWriteCommand command) {
        this.command = command;
        this.label = command.getLabel();
        this.selected = true;
    }

    public FileWriteCommandExecutor(String label) {
        this.label = label;
        this.selected = true;
    }

    public FileWriteCommandExecutor() {
        this.selected = true;
    }

    public FileWriteCommand getCommand() {
        return this.command;
    }

    public void setCommand(FileWriteCommand command) {
        this.command = command;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void execute() {
        if (this.selected) {
            if (!StringUtils.isEmpty((String)this.label)) {
                logger.info("executing command : " + this.label);
            }
            if (this.command != null) {
                try {
                    this.command.execute();
                }
                catch (Exception e) {
                    logger.error("command " + this.label + " has failed : " + e.getClass().getSimpleName() + " - " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

