/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.commands.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.sklsft.generator.model.metadata.FileType;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;

public abstract class SingleFileWriteCommand
implements FileWriteCommand {
    protected static final char CHAR_34 = '\"';
    private static final String SKIP_LINE = "\n";
    protected FileType fileType;
    private String qualifiedFileName;
    private String folderName;
    protected StringWriter writer = new StringWriter();
    private int rowCount = 0;
    protected Path filePath;

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public SingleFileWriteCommand(String folderName, String fileName, FileType fileType) {
        this.fileType = fileType;
        this.folderName = folderName;
        this.qualifiedFileName = fileName + fileType.getExtension();
        this.filePath = Paths.get(folderName + File.separator + this.qualifiedFileName, new String[0]);
    }

    @Override
    public String getLabel() {
        return this.filePath.toString();
    }

    @Override
    public void execute() throws IOException {
        Path folderPath = Paths.get(this.folderName, new String[0]);
        if (!Files.exists(folderPath, new LinkOption[0])) {
            Files.createDirectories(folderPath, new FileAttribute[0]);
        }
        this.writeContent();
        try (BufferedWriter fileWriter = Files.newBufferedWriter(this.filePath, this.fileType.getEncoding(), new OpenOption[0]);){
            fileWriter.write(this.writer.toString());
            fileWriter.flush();
        }
    }

    protected abstract void writeContent() throws IOException;

    protected final void write(String content) {
        this.writer.append(content);
    }

    protected final void writeLine(String line) {
        this.write(line);
        this.skipLine();
    }

    protected final void skipLine() {
        this.writer.append(SKIP_LINE);
        ++this.rowCount;
    }

    private final String getNotOverridableContent() throws IOException {
        if (Files.exists(this.filePath, new LinkOption[0])) {
            List<String> lines = Files.readAllLines(this.filePath, this.fileType.getEncoding());
            boolean isNotOverridable = false;
            StringWriter notOverridableContentWriter = new StringWriter();
            for (String line : lines) {
                if (line.contains(this.fileType.getSpecificCodeStartMark())) {
                    isNotOverridable = true;
                    continue;
                }
                if (line.contains(this.fileType.getSpecificCodeEndMark())) {
                    isNotOverridable = false;
                    continue;
                }
                if (!isNotOverridable) continue;
                notOverridableContentWriter.append(line + SKIP_LINE);
            }
            return notOverridableContentWriter.toString();
        }
        return "";
    }

    protected final void writeNotOverridableContent() throws IOException {
        String content = this.getNotOverridableContent();
        this.writeLine(this.fileType.getSpecificCodeStartMark());
        this.write(content);
        this.writeLine(this.fileType.getSpecificCodeEndMark());
    }
}

