/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.commands.impl;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;

public class ResourcesFileWriteCommand
implements FileWriteCommand {
    private static String separator = "/";
    private Class<?> clazz;
    private String resourcesRootPath;
    private String targetRootPath;
    private Project project;

    public ResourcesFileWriteCommand(Project project, Class<?> clazz, String resourcesRootPath, String targetRootPath) {
        this.project = project;
        this.clazz = clazz;
        this.resourcesRootPath = resourcesRootPath;
        this.targetRootPath = targetRootPath;
    }

    @Override
    public String getLabel() {
        return "resources copied to " + this.targetRootPath;
    }

    @Override
    public void execute() throws IOException {
        URL url = this.clazz.getResource(this.resourcesRootPath);
        File targetFolder = new File(this.project.workspaceFolder + File.separator + this.targetRootPath);
        File resourcesFolder = null;
        if (url.getProtocol().equals("file")) {
            resourcesFolder = new File(url.getPath());
            FileUtils.copyDirectoryToDirectory((File)resourcesFolder, (File)targetFolder);
        } else {
            File jar;
            try {
                jar = new File(this.clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException("failed to jar path", e);
            }
            try (FileSystem jarMount = FileSystems.newFileSystem(jar.toPath(), null);){
                Path resourcesPath = jarMount.getPath(this.resourcesRootPath, new String[0]);
                Path targetPath = targetFolder.toPath();
                this.copyRecursively(resourcesPath, targetPath);
            }
        }
    }

    private void copyRecursively(Path resourcesPath, Path targetPath) throws IOException {
        File childTargetFile = new File(targetPath.toFile().getPath() + separator + resourcesPath.getFileName());
        Path childTargetPath = childTargetFile.toPath();
        if (Files.isDirectory(resourcesPath, new LinkOption[0])) {
            childTargetPath = Files.createDirectories(childTargetPath, new FileAttribute[0]);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(resourcesPath);){
                for (Path childResourcesPath : stream) {
                    this.copyRecursively(childResourcesPath, childTargetPath);
                }
            }
        } else {
            Files.copy(resourcesPath, childTargetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public int getRowCount() {
        return 0;
    }
}

