/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.layers.database;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.database.configuration.postgresql.PostgresqlDataSourceContextFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.database.configuration.postgresql.PostgresqlMainDefinitionFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.database.postgresql.PostgresqlTableDefinitionFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.database.postgresql.PostgresqlTableFkDefinitionFileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class PostgresDatabaseLayer
extends AbstractLayer {
    public PostgresDatabaseLayer() {
        super("Database definition");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        return null;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode dataSourceContextTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PostgresqlDataSourceContextFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)dataSourceContextTreeNode);
        FileWriteCommandTreeNode mainFileTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PostgresqlMainDefinitionFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)mainFileTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode databaseTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode definitionFilesTreeNode = new FileWriteCommandTreeNode("Definition Files");
        databaseTreeNode.add((MutableTreeNode)definitionFilesTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            definitionFilesTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Table table : myPackage.tables) {
                packageTreeNode.add((MutableTreeNode)new FileWriteCommandTreeNode((FileWriteCommand)new PostgresqlTableDefinitionFileWriteCommand(table)));
                packageTreeNode.add((MutableTreeNode)new FileWriteCommandTreeNode((FileWriteCommand)new PostgresqlTableFkDefinitionFileWriteCommand(table)));
            }
        }
        return databaseTreeNode;
    }
}

