/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.layers.database;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.database.configuration.oracle.OracleDataSourceContextFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.database.oracle.OracleMainDefinitionFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.database.oracle.OracleTableDefinitionFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.database.oracle.OracleTableFkDefinitionFileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class OracleDatabaseLayer
extends AbstractLayer {
    public OracleDatabaseLayer() {
        super("Database definition");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        return null;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode dataSourceContextTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new OracleDataSourceContextFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)dataSourceContextTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode databaseTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode definitionFilesTreeNode = new FileWriteCommandTreeNode("Definition Files");
        databaseTreeNode.add((MutableTreeNode)definitionFilesTreeNode);
        FileWriteCommandTreeNode mainFileTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new OracleMainDefinitionFileWriteCommand(project));
        definitionFilesTreeNode.add((MutableTreeNode)mainFileTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            definitionFilesTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Table table : myPackage.tables) {
                packageTreeNode.add((MutableTreeNode)new FileWriteCommandTreeNode((FileWriteCommand)new OracleTableDefinitionFileWriteCommand(table)));
                packageTreeNode.add((MutableTreeNode)new FileWriteCommandTreeNode((FileWriteCommand)new OracleTableFkDefinitionFileWriteCommand(table)));
            }
        }
        return databaseTreeNode;
    }
}

