/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.layers;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.services.BaseServiceImplFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.services.ServiceImplFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.services.configuration.ServicesPomFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.services.configuration.SpringServicesFileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class ServiceLayer
extends AbstractLayer {
    public ServiceLayer() {
        super("Services / Backend implementation");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        return null;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode springServicesTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringServicesFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)springServicesTreeNode);
        FileWriteCommandTreeNode servicesPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new ServicesPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)servicesPomTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode serviceLayerTreeNode = new FileWriteCommandTreeNode();
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            serviceLayerTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode baseBeanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new BaseServiceImplFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)baseBeanTreeNode);
                FileWriteCommandTreeNode beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new ServiceImplFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)beanTreeNode);
            }
        }
        return serviceLayerTreeNode;
    }
}

