/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.skeletons.core.layers;

import javax.swing.tree.MutableTreeNode;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.skeletons.commands.interfaces.FileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.population.BeanPopulatorCommandFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.population.OneToManyComponentPopulatorCommandFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.population.configuration.LogbackPopulatorFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.population.configuration.PopulatorPomFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.population.configuration.PopulatorProjectPropertiesFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.population.configuration.SpringPopulatorFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.population.configuration.SpringPopulatorRepositoryFileWriteCommand;
import org.sklsft.generator.skeletons.core.commands.population.resources.PopulatorLauncherFileWriteCommand;
import org.sklsft.generator.skeletons.layers.AbstractLayer;
import org.sklsft.generator.skeletons.tree.FileWriteCommandTreeNode;

public class PopulatorLayer
extends AbstractLayer {
    public PopulatorLayer() {
        super("Population");
    }

    public FileWriteCommandTreeNode getResourcesNode(Project project) {
        FileWriteCommandTreeNode resourcesTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode populatorLauncherTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PopulatorLauncherFileWriteCommand(project));
        resourcesTreeNode.add((MutableTreeNode)populatorLauncherTreeNode);
        return resourcesTreeNode;
    }

    public FileWriteCommandTreeNode getConfigurationNode(Project project) {
        FileWriteCommandTreeNode configurationTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode populatorPomTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PopulatorPomFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)populatorPomTreeNode);
        FileWriteCommandTreeNode springPopulatorRepositoryTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringPopulatorRepositoryFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)springPopulatorRepositoryTreeNode);
        FileWriteCommandTreeNode springPopulatorTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new SpringPopulatorFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)springPopulatorTreeNode);
        FileWriteCommandTreeNode logbackPopulatorTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new LogbackPopulatorFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)logbackPopulatorTreeNode);
        FileWriteCommandTreeNode populatorPropertiesTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new PopulatorProjectPropertiesFileWriteCommand(project));
        configurationTreeNode.add((MutableTreeNode)populatorPropertiesTreeNode);
        return configurationTreeNode;
    }

    public FileWriteCommandTreeNode getGenerationNode(Project project) {
        FileWriteCommandTreeNode populatorLayerTreeNode = new FileWriteCommandTreeNode();
        FileWriteCommandTreeNode commandTreeNode = new FileWriteCommandTreeNode("Population commands");
        populatorLayerTreeNode.add((MutableTreeNode)commandTreeNode);
        for (Package myPackage : project.model.packages) {
            FileWriteCommandTreeNode packageTreeNode = new FileWriteCommandTreeNode(myPackage.name);
            commandTreeNode.add((MutableTreeNode)packageTreeNode);
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent) continue;
                FileWriteCommandTreeNode beanTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new BeanPopulatorCommandFileWriteCommand(bean));
                packageTreeNode.add((MutableTreeNode)beanTreeNode);
                for (OneToManyComponent oneToManyComponent : bean.oneToManyComponentList) {
                    FileWriteCommandTreeNode oneToManyComponentTreeNode = new FileWriteCommandTreeNode((FileWriteCommand)new OneToManyComponentPopulatorCommandFileWriteCommand(oneToManyComponent));
                    packageTreeNode.add((MutableTreeNode)oneToManyComponentTreeNode);
                }
            }
        }
        return populatorLayerTreeNode;
    }
}

